/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.api.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountAccess;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.AccountReport;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.DepositAccount;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"TPP Accounts management"})
public interface TppAccountsRestApi {
    public static final String BASE_PATH = "/tpp/accounts";

    @ApiOperation(value="Create account for a given user", notes="Endpoint to a deposit account for a user with given ID", authorizations={@Authorization(value="apiKey")})
    @PostMapping
    public ResponseEntity<Void> createAccount(@RequestParam(value="userId") String var1, @RequestBody DepositAccount var2);

    @ApiOperation(value="Update Account access for a given user", notes="Endpoint to update account access with given iban for a user with given ID ", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/access"})
    public ResponseEntity<Void> updateAccountAccess(@RequestBody AccountAccess var1);

    @ApiOperation(value="Get list of Accessible Accounts", notes="Returns the list of all accounts connected to the given TPP", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO[].class, message="List of accounts accessible to the TPP.")})
    @GetMapping
    public ResponseEntity<List<AccountDetailsTO>> getAllAccounts();

    @ApiOperation(value="Get list of Accessible Accounts, paged view", notes="Returns the list of all accounts connected to the given TPP", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO[].class, message="List of accounts accessible to the TPP.")})
    @GetMapping(value={"/page"})
    public ResponseEntity<CustomPageImpl<AccountDetailsTO>> getAllAccounts(@RequestParam(value="queryParam", required=false, defaultValue="") String var1, @RequestParam(value="page", required=false, defaultValue="0") int var2, @RequestParam(value="size", required=false, defaultValue="25") int var3);

    @ApiOperation(value="Get an account by its ID", notes="Returns the account by its ID if it belongs to the TPP", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO[].class, message="Account details by its ID if it is accessible by the TPP")})
    @GetMapping(value={"/{accountId}"})
    public ResponseEntity<AccountDetailsTO> getSingleAccount(@PathVariable(value="accountId") String var1);

    @ApiOperation(value="Get an account report by its ID", notes="Returns the account report by its ID if it belongs to the TPP", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountReportTO.class, message="Account report by its ID if it is accessible by the TPP")})
    @GetMapping(value={"/report/{accountId}"})
    public ResponseEntity<AccountReport> accountReport(@PathVariable(value="accountId") String var1);

    @ApiOperation(value="Deposit cash to an account by its ID", notes="Deposits cash to the account by its ID if it belongs to the TPP", authorizations={@Authorization(value="apiKey")})
    @ApiResponses(value={@ApiResponse(code=200, response=AccountDetailsTO[].class, message="Deposits cash to the account by its ID")})
    @PostMapping(value={"/{accountId}/deposit-cash"})
    public ResponseEntity<Void> depositCash(@PathVariable(value="accountId") String var1, @RequestBody AmountTO var2);

    @GetMapping(value={"/example"})
    @ApiOperation(value="Download account template", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<Resource> downloadAccountTemplate();

    @ApiOperation(value="Block/Unblock Account", notes="Changes block state for given account, returns status being set to the block", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/status"})
    public ResponseEntity<Boolean> changeStatus(@RequestParam(value="accountId") String var1);

    @ApiOperation(value="Update credit limit for account", notes="Enables/Disables credit limit for certain account", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/credit"})
    public ResponseEntity<Void> updateCreditLimit(@RequestParam(value="accountId") String var1, @RequestBody BigDecimal var2);
}

