/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.api.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"TPP Admin API"})
public interface TppAdminRestApi {
    public static final String BASE_PATH = "/tpp/admin";
    public static final String COUNTRY = "country";
    public static final String TPP_ID = "tppId";
    public static final String USER_ID = "userId";
    public static final String TPP_LOGIN = "tppLogin";
    public static final String USER_LOGIN = "userLogin";
    public static final String ROLE = "role";
    public static final String BLOCKED = "blocked";
    public static final String IBAN_PARAM = "ibanParam";

    @ApiOperation(value="Get users", notes="Retrieves Page of Users with filters", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/users"})
    public ResponseEntity<CustomPageImpl<UserExtendedTO>> users(@RequestParam(value="country", defaultValue="", required=false) String var1, @RequestParam(value="tppId", defaultValue="", required=false) String var2, @RequestParam(value="tppLogin", defaultValue="", required=false) String var3, @RequestParam(value="userLogin", defaultValue="", required=false) String var4, @RequestParam(value="role", required=false) UserRoleTO var5, @RequestParam(value="blocked", required=false) Boolean var6, @RequestParam(value="page") int var7, @RequestParam(value="size") int var8);

    @ApiOperation(value="Update user", notes="Update user", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/users"})
    public ResponseEntity<Void> user(@RequestBody UserTO var1);

    @ApiOperation(value="Retrieves Page of accounts with filters", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/account"})
    public ResponseEntity<CustomPageImpl<AccountDetailsExtendedTO>> accounts(@RequestParam(value="country", defaultValue="", required=false) String var1, @RequestParam(value="tppId", defaultValue="", required=false) String var2, @RequestParam(value="tppLogin", defaultValue="", required=false) String var3, @RequestParam(value="ibanParam", required=false, defaultValue="") String var4, @RequestParam(value="blocked", required=false) Boolean var5, @RequestParam(value="page") int var6, @RequestParam(value="size") int var7);

    @ApiOperation(value="Register new User", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/register"})
    public ResponseEntity<Void> register(@RequestBody User var1, @RequestParam(value="tppId") String var2);

    @ApiOperation(value="Register new Admin", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/register/admin"})
    public ResponseEntity<Void> admin(@RequestBody User var1);

    @ApiOperation(value="Retrieves Users with Admin rights", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/admins"})
    public ResponseEntity<CustomPageImpl<UserTO>> admins(@RequestParam(value="page") int var1, @RequestParam(value="size") int var2);

    @ApiOperation(value="Remove Tpp", authorizations={@Authorization(value="apiKey")})
    @DeleteMapping
    public ResponseEntity<Void> remove(String var1);

    @ApiOperation(value="Set password for Tpp", notes="Changes password for given Tpp", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/password"})
    public ResponseEntity<Void> updatePassword(@RequestParam(value="tppId") String var1, @RequestParam(value="pin") String var2);

    @ApiOperation(value="Block/Unblock User", notes="Changes block state for given user, returns status being set to the block", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/status"})
    public ResponseEntity<Boolean> changeStatus(@RequestParam(value="userId") String var1);
}

