/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.api.resource;

import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags={"TPP Revert Point API"})
public interface TppRecoveryPointRestApi {
    public static final String BASE_PATH = "/tpp/recovery";

    @ApiOperation(value="Get recovery point by id", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/point/{id}"})
    public ResponseEntity<RecoveryPointTO> point(@PathVariable(value="id") Long var1);

    @ApiOperation(value="Get all recovery points for TPP", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/points"})
    public ResponseEntity<List<RecoveryPointTO>> points();

    @ApiOperation(value="Create a new recovery point", authorizations={@Authorization(value="apiKey")})
    @PostMapping(value={"/point"})
    public ResponseEntity<Void> createPoint(@RequestBody RecoveryPointTO var1);

    @ApiOperation(value="Remove existing recovery point by id", authorizations={@Authorization(value="apiKey")})
    @DeleteMapping(value={"/point/{id}"})
    public ResponseEntity<Void> deletePoint(@PathVariable(value="id") Long var1);
}

