/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.api.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"TPP data uploader"})
public interface TppDataUploaderRestApi {
    public static final String BASE_PATH = "/tpp/data";

    @ApiOperation(value="Upload YAML file with basic test data", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/upload"})
    public ResponseEntity<String> uploadData(@RequestBody MultipartFile var1);

    @ApiOperation(value="Generate test data and upload it to Ledgers", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/generate/{currency}"})
    public ResponseEntity<Resource> generateData(@RequestParam boolean var1, @PathVariable(value="currency") String var2);

    @ApiOperation(value="Generate random IBAN", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/generate/iban"})
    public ResponseEntity<String> generateIban(@RequestParam(value="tppId") String var1);

    @ApiOperation(value="Upload CSV file with transactions list", authorizations={@Authorization(value="apiKey")})
    @PutMapping(value={"/upload/transactions"})
    public ResponseEntity<Map<String, String>> uploadTransactions(@RequestBody MultipartFile var1);

    @GetMapping(value={"/example"})
    @ApiOperation(value="Download transaction template", authorizations={@Authorization(value="apiKey")})
    public ResponseEntity<Resource> downloadTransactionTemplate();
}

