/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.rest.api.resource;

import de.adorsys.psd2.sandbox.tpp.rest.api.domain.BankCodeStructure;
import de.adorsys.psd2.sandbox.tpp.rest.api.domain.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.Currency;
import java.util.Map;
import java.util.Set;
import org.iban4j.CountryCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"TPP main API"})
public interface TppRestApi {
    public static final String BASE_PATH = "/tpp";

    @ApiOperation(value="Login for TPP")
    @PostMapping(value={"/login"})
    public void login(@RequestHeader(value="login") String var1, @RequestHeader(value="pin") String var2);

    @ApiOperation(value="Get supported currencies list", authorizations={@Authorization(value="apiKey")})
    @GetMapping(value={"/currencies"})
    public ResponseEntity<Set<Currency>> getCurrencies();

    @ApiOperation(value="Get country codes")
    @GetMapping(value={"/codes"})
    public ResponseEntity<Map<CountryCode, String>> getSupportedCountryCodes();

    @ApiOperation(value="Get country code character type and country code length")
    @GetMapping(value={"/country/codes/structure"})
    public ResponseEntity<BankCodeStructure> getBankCodeStructure(@RequestParam String var1);

    @ApiOperation(value="Register new TPP")
    @PostMapping(value={"/register"})
    public ResponseEntity<Void> register(@RequestBody User var1);

    @ApiOperation(value="Remove Tpp", authorizations={@Authorization(value="apiKey")})
    @DeleteMapping(value={"/self"})
    public ResponseEntity<Void> remove();

    @ApiOperation(value="Remove transactions for account in Tpp", authorizations={@Authorization(value="apiKey")})
    @DeleteMapping(value={"/account/{accountId}"})
    public ResponseEntity<Void> transactions(@PathVariable String var1);
}

