/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.cms.impl.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.service.ConsentServiceInternal;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AisConsent;
import de.adorsys.psd2.sandbox.tpp.cms.api.service.ConsentService;
import de.adorsys.psd2.sandbox.tpp.cms.impl.mapper.ConsentMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsentServiceImpl
implements ConsentService {
    private static final Logger log = LoggerFactory.getLogger(ConsentServiceImpl.class);
    private final ConsentServiceInternal consentServiceInternal;
    private final ConsentMapper mapper;

    @Transactional
    public List<String> generateConsents(List<AisConsent> consents) {
        List<String> consentIds = consents.stream().map(this.mapper::mapToCmsConsent).map(this::doCreateConsent).filter(Objects::nonNull).map(CmsResponse::getPayload).map(CmsCreateConsentResponse::getConsentId).collect(Collectors.toList());
        return this.updateConsentsStatus(consentIds);
    }

    private CmsResponse<CmsCreateConsentResponse> doCreateConsent(CmsConsent cmsConsent) {
        return this.consentServiceInternal.createConsent(cmsConsent);
    }

    private List<String> updateConsentsStatus(List<String> consentIds) {
        consentIds.forEach(id -> {
            try {
                this.consentServiceInternal.updateConsentStatusById(id, ConsentStatus.VALID);
            }
            catch (WrongChecksumException e) {
                log.error("Could not update Consent: {} with status: {}", id, (Object)ConsentStatus.VALID.name());
            }
        });
        return consentIds;
    }

    public ConsentServiceImpl(ConsentServiceInternal consentServiceInternal, ConsentMapper mapper) {
        this.consentServiceInternal = consentServiceInternal;
        this.mapper = mapper;
    }
}

