/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.cms.impl.service;

import de.adorsys.psd2.sandbox.tpp.cms.api.service.CmsDbNativeService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmsDbDbNativeServiceImpl
implements CmsDbNativeService {
    private static final Logger log = LoggerFactory.getLogger(CmsDbDbNativeServiceImpl.class);
    private final ResourceLoader loader;
    private static final String ROLLBACK_CMS = "classpath:rollbackCms.sql";
    private static final String DELETE_CONSENTS_IN_CMS = "classpath:deleteConsents.sql";
    private EntityManager cmsEntityManager;

    @Qualifier(value="cmsEntityManager")
    @Autowired
    public void setCmsEntityManager(EntityManager cmsEntityManager) {
        this.cmsEntityManager = cmsEntityManager;
    }

    @Transactional(value="cmsTransactionManager")
    public void revertDatabase(List<String> userIds, LocalDateTime databaseStateDateTime) {
        log.debug("Reverting CMS DB for users: " + Arrays.toString(userIds.toArray()) + ", timestamp: " + databaseStateDateTime.toString());
        this.cmsEntityManager.createNativeQuery(this.loadQueryFromFile(ROLLBACK_CMS)).setParameter(1, userIds).setParameter(2, (Object)databaseStateDateTime).executeUpdate();
    }

    @Transactional(value="cmsTransactionManager")
    public void deleteConsentsByUserIds(List<String> userIds) {
        log.debug("Deleting AIS-specific data in CMS DB (if present) for users: " + Arrays.toString(userIds.toArray()));
        this.cmsEntityManager.createNativeQuery(this.loadQueryFromFile(DELETE_CONSENTS_IN_CMS)).setParameter(1, userIds).executeUpdate();
    }

    private String loadQueryFromFile(String filename) {
        try {
            InputStream stream = this.loader.getResource(filename).getInputStream();
            return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading CMS SQL query from file: " + filename);
        }
    }

    public CmsDbDbNativeServiceImpl(ResourceLoader loader) {
        this.loader = loader;
    }
}

