/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.sandbox.tpp.cms.impl.mapper;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AccountAccessInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AccountReferenceInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AisConsent;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.PsuIdDataInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyRedirectUri;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyRole;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.UserAccountAccessType;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentTppInformation;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ConsentMapper {
    private final ConsentDataMapper consentDataMapper;

    public CmsConsent mapToCmsConsent(AisConsent consent) {
        CmsConsent cmsConsent = new CmsConsent();
        AccountAccessInfo access = consent.getAccess();
        AisConsentData aisConsentData = new AisConsentData(this.toCmsAccessType(consent.getAvailableAccounts()), this.toCmsAccessType(consent.getAllPsd2()), this.toCmsAccessType(consent.getAvailableAccountsWithBalance()), false);
        byte[] aisConsentDataBytes = this.consentDataMapper.getBytesFromConsentData((Object)aisConsentData);
        cmsConsent.setConsentData(aisConsentDataBytes);
        ConsentTppInformation tppInformation = new ConsentTppInformation();
        tppInformation.setTppInfo(this.toTppInfo(consent.getTppInfo()));
        tppInformation.setTppFrequencyPerDay(consent.getRequestedFrequencyPerDay());
        tppInformation.setTppRedirectPreferred(consent.isTppRedirectPreferred());
        cmsConsent.setTppInformation(tppInformation);
        AuthorisationTemplate authorisationTemplate = new AuthorisationTemplate();
        authorisationTemplate.setTppRedirectUri(this.toTppRedirectUti(consent.getTppInfo().getCancelTppRedirectUri()));
        cmsConsent.setAuthorisationTemplate(authorisationTemplate);
        cmsConsent.setFrequencyPerDay(consent.getAllowedFrequencyPerDay());
        cmsConsent.setInternalRequestId(UUID.randomUUID().toString());
        cmsConsent.setValidUntil(consent.getValidUntil());
        cmsConsent.setRecurringIndicator(consent.isRecurringIndicator());
        cmsConsent.setPsuIdDataList(Collections.singletonList(this.toPsuIdData(consent.getPsuInfo())));
        cmsConsent.setConsentType(ConsentType.AIS);
        cmsConsent.setTppAccountAccesses(this.toAccountAccess(access));
        cmsConsent.setAspspAccountAccesses(AccountAccess.EMPTY_ACCESS);
        cmsConsent.setConsentStatus(ConsentStatus.RECEIVED);
        return cmsConsent;
    }

    private AccountAccess toAccountAccess(AccountAccessInfo access) {
        List<AccountReference> accounts = this.toAccountReferences(access.getAccounts());
        List<AccountReference> balances = this.toAccountReferences(access.getBalances());
        List<AccountReference> transactions = this.toAccountReferences(access.getTransactions());
        return new AccountAccess(accounts, balances, transactions, null);
    }

    private List<AccountReference> toAccountReferences(List<AccountReferenceInfo> source) {
        if (CollectionUtils.isNotEmpty(source)) {
            return source.stream().map(r -> new AccountReference(AccountReferenceType.valueOf((String)r.getAccountType().name()), r.getAccountIdentifier(), Currency.getInstance(r.getCurrency()), r.getResourceId(), r.getAspspAccountId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private PsuIdData toPsuIdData(PsuIdDataInfo psuInfo) {
        return new PsuIdData(psuInfo.getPsuId(), psuInfo.getPsuIdType(), psuInfo.getPsuCorporateId(), psuInfo.getPsuCorporateIdType(), null);
    }

    private AccountAccessType toCmsAccessType(UserAccountAccessType type) {
        return AccountAccessType.valueOf((String)type.name());
    }

    private TppInfo toTppInfo(ThirdPartyInfo source) {
        TppInfo tppInfo = new TppInfo();
        tppInfo.setAuthorisationNumber(source.getAuthorisationNumber());
        tppInfo.setTppName(source.getTppName());
        tppInfo.setTppRoles(this.toTppRoles(source.getTppRoles()));
        tppInfo.setAuthorityId(source.getAuthorityId());
        tppInfo.setAuthorityName(source.getAuthorityName());
        tppInfo.setCountry(source.getCountry());
        tppInfo.setOrganisation(source.getOrganisation());
        tppInfo.setOrganisationUnit(source.getOrganisationUnit());
        tppInfo.setCity(source.getCity());
        tppInfo.setState(source.getState());
        tppInfo.setIssuerCN(source.getIssuerCN());
        tppInfo.setCancelTppRedirectUri(this.toTppRedirectUti(source.getCancelTppRedirectUri()));
        return tppInfo;
    }

    private List<TppRole> toTppRoles(List<ThirdPartyRole> tppRoles) {
        if (CollectionUtils.isNotEmpty(tppRoles)) {
            return tppRoles.stream().map(r -> TppRole.valueOf((String)r.name())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private TppRedirectUri toTppRedirectUti(ThirdPartyRedirectUri redirectUri) {
        return Optional.ofNullable(redirectUri).map(u -> new TppRedirectUri(u.getUri(), u.getNokUri())).orElseGet(() -> new TppRedirectUri("", null));
    }

    public ConsentMapper(ConsentDataMapper consentDataMapper) {
        this.consentDataMapper = consentDataMapper;
    }
}

