package de.adorsys.psd2.sandbox.tpp.cms.impl.mapper;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AccountAccessInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.AisConsent;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyInfo;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.ThirdPartyRole;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.UserAccountAccessType;
import de.adorsys.psd2.sandbox.tpp.cms.api.domain.UserAccountInfo;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-01-09T18:34:44+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class AisConsentMapperImpl implements AisConsentMapper {

    @Override
    public CreateAisConsentRequest toCmsAisConsentRequest(AisConsent aisConsent) {
        if ( aisConsent == null ) {
            return null;
        }

        CreateAisConsentRequest createAisConsentRequest = new CreateAisConsentRequest();

        createAisConsentRequest.setPsuData( toPsuIdData( aisConsent.getPsuInfo() ) );
        createAisConsentRequest.setTppInfo( thirdPartyInfoToTppInfo( aisConsent.getTppInfo() ) );
        createAisConsentRequest.setAllowedFrequencyPerDay( aisConsent.getAllowedFrequencyPerDay() );
        createAisConsentRequest.setRequestedFrequencyPerDay( aisConsent.getRequestedFrequencyPerDay() );
        createAisConsentRequest.setAccess( toAisAccountAccessInfo( aisConsent.getAccess() ) );
        createAisConsentRequest.setValidUntil( aisConsent.getValidUntil() );
        createAisConsentRequest.setRecurringIndicator( aisConsent.isRecurringIndicator() );
        createAisConsentRequest.setTppRedirectPreferred( aisConsent.isTppRedirectPreferred() );
        createAisConsentRequest.setCombinedServiceIndicator( aisConsent.isCombinedServiceIndicator() );

        return createAisConsentRequest;
    }

    @Override
    public AisAccountAccessInfo toAisAccountAccessInfo(AccountAccessInfo info) {
        if ( info == null ) {
            return null;
        }

        AisAccountAccessInfo aisAccountAccessInfo = new AisAccountAccessInfo();

        aisAccountAccessInfo.setAccounts( userAccountInfoListToAccountInfoList( info.getAccounts() ) );
        aisAccountAccessInfo.setBalances( userAccountInfoListToAccountInfoList( info.getBalances() ) );
        aisAccountAccessInfo.setTransactions( userAccountInfoListToAccountInfoList( info.getTransactions() ) );
        aisAccountAccessInfo.setAvailableAccounts( userAccountAccessTypeToAccountAccessType( info.getAvailableAccounts() ) );
        aisAccountAccessInfo.setAllPsd2( userAccountAccessTypeToAccountAccessType( info.getAllPsd2() ) );
        aisAccountAccessInfo.setAvailableAccountsWithBalance( userAccountAccessTypeToAccountAccessType( info.getAvailableAccountsWithBalance() ) );

        return aisAccountAccessInfo;
    }

    protected TppRole thirdPartyRoleToTppRole(ThirdPartyRole thirdPartyRole) {
        if ( thirdPartyRole == null ) {
            return null;
        }

        TppRole tppRole;

        switch ( thirdPartyRole ) {
            case PISP: tppRole = TppRole.PISP;
            break;
            case AISP: tppRole = TppRole.AISP;
            break;
            case PIISP: tppRole = TppRole.PIISP;
            break;
            case ASPSP: tppRole = TppRole.ASPSP;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + thirdPartyRole );
        }

        return tppRole;
    }

    protected List<TppRole> thirdPartyRoleListToTppRoleList(List<ThirdPartyRole> list) {
        if ( list == null ) {
            return null;
        }

        List<TppRole> list1 = new ArrayList<TppRole>( list.size() );
        for ( ThirdPartyRole thirdPartyRole : list ) {
            list1.add( thirdPartyRoleToTppRole( thirdPartyRole ) );
        }

        return list1;
    }

    protected TppInfo thirdPartyInfoToTppInfo(ThirdPartyInfo thirdPartyInfo) {
        if ( thirdPartyInfo == null ) {
            return null;
        }

        TppInfo tppInfo = new TppInfo();

        tppInfo.setAuthorisationNumber( thirdPartyInfo.getAuthorisationNumber() );
        tppInfo.setTppName( thirdPartyInfo.getTppName() );
        tppInfo.setTppRoles( thirdPartyRoleListToTppRoleList( thirdPartyInfo.getTppRoles() ) );
        tppInfo.setAuthorityId( thirdPartyInfo.getAuthorityId() );
        tppInfo.setAuthorityName( thirdPartyInfo.getAuthorityName() );
        tppInfo.setCountry( thirdPartyInfo.getCountry() );
        tppInfo.setOrganisation( thirdPartyInfo.getOrganisation() );
        tppInfo.setOrganisationUnit( thirdPartyInfo.getOrganisationUnit() );
        tppInfo.setCity( thirdPartyInfo.getCity() );
        tppInfo.setState( thirdPartyInfo.getState() );
        tppInfo.setCancelTppRedirectUri( toTppRedirectUti( thirdPartyInfo.getCancelTppRedirectUri() ) );
        tppInfo.setIssuerCN( thirdPartyInfo.getIssuerCN() );

        return tppInfo;
    }

    protected List<AccountInfo> userAccountInfoListToAccountInfoList(List<UserAccountInfo> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountInfo> list1 = new ArrayList<AccountInfo>( list.size() );
        for ( UserAccountInfo userAccountInfo : list ) {
            list1.add( toAccountInfo( userAccountInfo ) );
        }

        return list1;
    }

    protected AccountAccessType userAccountAccessTypeToAccountAccessType(UserAccountAccessType userAccountAccessType) {
        if ( userAccountAccessType == null ) {
            return null;
        }

        AccountAccessType accountAccessType;

        switch ( userAccountAccessType ) {
            case ALL_ACCOUNTS: accountAccessType = AccountAccessType.ALL_ACCOUNTS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userAccountAccessType );
        }

        return accountAccessType;
    }
}
