package de.adorsys.ledgers.oba.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.ais.CmsAccountReference;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-08-30T17:03:57+0200",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_212 (Oracle Corporation)"
)
@Component
public class SinglePaymentMapperImpl implements SinglePaymentMapper {

    @Autowired
    private TimeMapper timeMapper;

    @Override
    public SinglePaymentTO toPayment(CmsSinglePayment payment) {
        if ( payment == null ) {
            return null;
        }

        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();

        singlePaymentTO.setPaymentId( payment.getPaymentId() );
        singlePaymentTO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        singlePaymentTO.setDebtorAccount( cmsAccountReferenceToAccountReferenceTO( payment.getDebtorAccount() ) );
        singlePaymentTO.setInstructedAmount( cmsAmountToAmountTO( payment.getInstructedAmount() ) );
        singlePaymentTO.setCreditorAccount( cmsAccountReferenceToAccountReferenceTO( payment.getCreditorAccount() ) );
        singlePaymentTO.setCreditorAgent( payment.getCreditorAgent() );
        singlePaymentTO.setCreditorName( payment.getCreditorName() );
        singlePaymentTO.setCreditorAddress( cmsAddressToAddressTO( payment.getCreditorAddress() ) );
        singlePaymentTO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        singlePaymentTO.setPaymentStatus( transactionStatusToTransactionStatusTO( payment.getPaymentStatus() ) );
        singlePaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        singlePaymentTO.setRequestedExecutionTime( timeMapper.mapTime( payment.getRequestedExecutionTime() ) );

        singlePaymentTO.setPaymentProduct( de.adorsys.ledgers.oba.rest.server.mapper.ProductTOMapper.mapToPaymentProduct(payment.getPaymentProduct()) );

        return singlePaymentTO;
    }

    protected AccountReferenceTO cmsAccountReferenceToAccountReferenceTO(CmsAccountReference cmsAccountReference) {
        if ( cmsAccountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( cmsAccountReference.getIban() );
        accountReferenceTO.setBban( cmsAccountReference.getBban() );
        accountReferenceTO.setPan( cmsAccountReference.getPan() );
        accountReferenceTO.setMaskedPan( cmsAccountReference.getMaskedPan() );
        accountReferenceTO.setMsisdn( cmsAccountReference.getMsisdn() );
        accountReferenceTO.setCurrency( cmsAccountReference.getCurrency() );

        return accountReferenceTO;
    }

    protected AmountTO cmsAmountToAmountTO(CmsAmount cmsAmount) {
        if ( cmsAmount == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( cmsAmount.getCurrency() );
        amountTO.setAmount( cmsAmount.getAmount() );

        return amountTO;
    }

    protected AddressTO cmsAddressToAddressTO(CmsAddress cmsAddress) {
        if ( cmsAddress == null ) {
            return null;
        }

        AddressTO addressTO = new AddressTO();

        addressTO.setStreet( cmsAddress.getStreet() );
        addressTO.setBuildingNumber( cmsAddress.getBuildingNumber() );
        addressTO.setCity( cmsAddress.getCity() );
        addressTO.setPostalCode( cmsAddress.getPostalCode() );
        addressTO.setCountry( cmsAddress.getCountry() );

        return addressTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        if ( transactionStatus == null ) {
            return null;
        }

        TransactionStatusTO transactionStatusTO;

        switch ( transactionStatus ) {
            case ACCC: transactionStatusTO = TransactionStatusTO.ACCC;
            break;
            case ACCP: transactionStatusTO = TransactionStatusTO.ACCP;
            break;
            case ACSC: transactionStatusTO = TransactionStatusTO.ACSC;
            break;
            case ACSP: transactionStatusTO = TransactionStatusTO.ACSP;
            break;
            case ACTC: transactionStatusTO = TransactionStatusTO.ACTC;
            break;
            case ACWC: transactionStatusTO = TransactionStatusTO.ACWC;
            break;
            case ACWP: transactionStatusTO = TransactionStatusTO.ACWP;
            break;
            case RCVD: transactionStatusTO = TransactionStatusTO.RCVD;
            break;
            case PDNG: transactionStatusTO = TransactionStatusTO.PDNG;
            break;
            case RJCT: transactionStatusTO = TransactionStatusTO.RJCT;
            break;
            case CANC: transactionStatusTO = TransactionStatusTO.CANC;
            break;
            case ACFC: transactionStatusTO = TransactionStatusTO.ACFC;
            break;
            case PATC: transactionStatusTO = TransactionStatusTO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatus );
        }

        return transactionStatusTO;
    }
}
