package de.adorsys.ledgers.oba.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.ais.CmsAccountReference;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsPeriodicPayment;
import de.adorsys.psd2.xs2a.core.pis.FrequencyCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-08-30T17:03:57+0200",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_212 (Oracle Corporation)"
)
@Component
public class PeriodicPaymentMapperImpl implements PeriodicPaymentMapper {

    @Autowired
    private TimeMapper timeMapper;

    @Override
    public PeriodicPaymentTO toPayment(CmsPeriodicPayment payment) {
        if ( payment == null ) {
            return null;
        }

        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();

        periodicPaymentTO.setPaymentId( payment.getPaymentId() );
        periodicPaymentTO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        periodicPaymentTO.setDebtorAccount( cmsAccountReferenceToAccountReferenceTO( payment.getDebtorAccount() ) );
        periodicPaymentTO.setInstructedAmount( cmsAmountToAmountTO( payment.getInstructedAmount() ) );
        periodicPaymentTO.setCreditorAccount( cmsAccountReferenceToAccountReferenceTO( payment.getCreditorAccount() ) );
        periodicPaymentTO.setCreditorAgent( payment.getCreditorAgent() );
        periodicPaymentTO.setCreditorName( payment.getCreditorName() );
        periodicPaymentTO.setCreditorAddress( cmsAddressToAddressTO( payment.getCreditorAddress() ) );
        periodicPaymentTO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        periodicPaymentTO.setPaymentStatus( transactionStatusToTransactionStatusTO( payment.getPaymentStatus() ) );
        periodicPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        periodicPaymentTO.setRequestedExecutionTime( timeMapper.mapTime( payment.getRequestedExecutionTime() ) );
        periodicPaymentTO.setStartDate( payment.getStartDate() );
        periodicPaymentTO.setEndDate( payment.getEndDate() );
        periodicPaymentTO.setFrequency( frequencyCodeToFrequencyCodeTO( payment.getFrequency() ) );

        periodicPaymentTO.setExecutionRule( mapPisExecutionRule(payment.getExecutionRule()) );
        periodicPaymentTO.setPaymentProduct( de.adorsys.ledgers.oba.rest.server.mapper.ProductTOMapper.mapToPaymentProduct(payment.getPaymentProduct()) );
        periodicPaymentTO.setDayOfExecution( mapPisDayOfExecution(payment.getDayOfExecution()) );

        return periodicPaymentTO;
    }

    protected AccountReferenceTO cmsAccountReferenceToAccountReferenceTO(CmsAccountReference cmsAccountReference) {
        if ( cmsAccountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( cmsAccountReference.getIban() );
        accountReferenceTO.setBban( cmsAccountReference.getBban() );
        accountReferenceTO.setPan( cmsAccountReference.getPan() );
        accountReferenceTO.setMaskedPan( cmsAccountReference.getMaskedPan() );
        accountReferenceTO.setMsisdn( cmsAccountReference.getMsisdn() );
        accountReferenceTO.setCurrency( cmsAccountReference.getCurrency() );

        return accountReferenceTO;
    }

    protected AmountTO cmsAmountToAmountTO(CmsAmount cmsAmount) {
        if ( cmsAmount == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( cmsAmount.getCurrency() );
        amountTO.setAmount( cmsAmount.getAmount() );

        return amountTO;
    }

    protected AddressTO cmsAddressToAddressTO(CmsAddress cmsAddress) {
        if ( cmsAddress == null ) {
            return null;
        }

        AddressTO addressTO = new AddressTO();

        addressTO.setStreet( cmsAddress.getStreet() );
        addressTO.setBuildingNumber( cmsAddress.getBuildingNumber() );
        addressTO.setCity( cmsAddress.getCity() );
        addressTO.setPostalCode( cmsAddress.getPostalCode() );
        addressTO.setCountry( cmsAddress.getCountry() );

        return addressTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        if ( transactionStatus == null ) {
            return null;
        }

        TransactionStatusTO transactionStatusTO;

        switch ( transactionStatus ) {
            case ACCC: transactionStatusTO = TransactionStatusTO.ACCC;
            break;
            case ACCP: transactionStatusTO = TransactionStatusTO.ACCP;
            break;
            case ACSC: transactionStatusTO = TransactionStatusTO.ACSC;
            break;
            case ACSP: transactionStatusTO = TransactionStatusTO.ACSP;
            break;
            case ACTC: transactionStatusTO = TransactionStatusTO.ACTC;
            break;
            case ACWC: transactionStatusTO = TransactionStatusTO.ACWC;
            break;
            case ACWP: transactionStatusTO = TransactionStatusTO.ACWP;
            break;
            case RCVD: transactionStatusTO = TransactionStatusTO.RCVD;
            break;
            case PDNG: transactionStatusTO = TransactionStatusTO.PDNG;
            break;
            case RJCT: transactionStatusTO = TransactionStatusTO.RJCT;
            break;
            case CANC: transactionStatusTO = TransactionStatusTO.CANC;
            break;
            case ACFC: transactionStatusTO = TransactionStatusTO.ACFC;
            break;
            case PATC: transactionStatusTO = TransactionStatusTO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatus );
        }

        return transactionStatusTO;
    }

    protected FrequencyCodeTO frequencyCodeToFrequencyCodeTO(FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        FrequencyCodeTO frequencyCodeTO;

        switch ( frequencyCode ) {
            case DAILY: frequencyCodeTO = FrequencyCodeTO.DAILY;
            break;
            case WEEKLY: frequencyCodeTO = FrequencyCodeTO.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCodeTO = FrequencyCodeTO.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCodeTO = FrequencyCodeTO.ANNUAL;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return frequencyCodeTO;
    }
}
