/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReference;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentType;
import de.adorsys.ledgers.oba.rest.api.consentref.InvalidConsentException;
import de.adorsys.ledgers.oba.rest.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.rest.api.domain.OnlineBankingResponse;
import de.adorsys.ledgers.oba.rest.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.rest.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.rest.api.domain.ValidationCode;
import de.adorsys.ledgers.oba.rest.api.exception.PaymentAuthorizeException;
import de.adorsys.ledgers.oba.rest.api.resource.PISApi;
import de.adorsys.ledgers.oba.rest.server.auth.MiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.mapper.BulkPaymentMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.PeriodicPaymentMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.SinglePaymentMapper;
import de.adorsys.ledgers.oba.rest.server.resource.AbstractXISController;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.PISController;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.pis.CmsBulkPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.api.pis.CmsPeriodicPayment;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import feign.FeignException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuPisClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/pis")
@RequestMapping(value={"/pis"})
@Api(value="/pis", tags={"PSU PIS"}, description="Provides access to online banking payment functionality")
public class PISController
extends AbstractXISController
implements PISApi {
    @Autowired
    private CmsPsuPisClient cmsPsuPisClient;
    @Autowired
    private PaymentRestClient paymentRestClient;
    @Autowired
    private UserMgmtRestClient userMgmtRestClient;
    @Autowired
    private SinglePaymentMapper singlePaymentMapper;
    @Autowired
    private BulkPaymentMapper bulkPaymentMapper;
    @Autowired
    private PeriodicPaymentMapper periodicPaymentMapper;
    private ScaStatusTO scaStatus;
    private String tppNokRedirectUri;
    private String tppOkRedirectUri;

    public ResponseEntity<AuthorizeResponse> pisAuth(String redirectId, String encryptedPaymentId) {
        return this.auth(redirectId, ConsentType.PIS, encryptedPaymentId, this.request, this.response);
    }

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<PaymentAuthorizeResponse> login(String encryptedPaymentId, String authorisationId, String login, String pin, String consentCookieString) {
        PaymentWorkflow workflow;
        try {
            workflow = this.identifyPayment(encryptedPaymentId, authorisationId, false, consentCookieString, login, this.response, null);
            CmsPaymentResponse payment = workflow.getPaymentResponse();
            this.scaStatus = ScaStatusTO.RECEIVED;
            this.tppNokRedirectUri = payment.getTppNokRedirectUri();
            this.tppOkRedirectUri = payment.getTppOkRedirectUri();
        }
        catch (PaymentAuthorizeException e) {
            return e.getError();
        }
        ResponseEntity authoriseForConsent = this.userMgmtRestClient.authoriseForConsent(login, pin, workflow.paymentId(), workflow.authId(), OpTypeTO.PAYMENT);
        this.processSCAResponse(workflow, (SCAResponseTO)authoriseForConsent.getBody());
        boolean success = AuthUtils.success((ResponseEntity)authoriseForConsent);
        if (success) {
            String psuId = AuthUtils.psuId((BearerTokenTO)workflow.bearerToken());
            try {
                this.updateAuthorisationStatus(workflow, psuId, this.response);
                this.initiatePayment(workflow, this.response);
                if (workflow.singleScaMethod()) {
                    ScaUserDataTO scaUserDataTO = (ScaUserDataTO)workflow.scaMethods().iterator().next();
                    this.selectMethod(scaUserDataTO.getId(), workflow);
                }
                this.updateScaStatusPaymentStatusConsentData(psuId, workflow);
            }
            catch (PaymentAuthorizeException e) {
                return e.getError();
            }
            switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$sca$ScaStatusTO[workflow.scaStatus().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
                    return ResponseEntity.ok((Object)workflow.getAuthResponse());
                }
            }
            this.responseUtils.removeCookies(this.response);
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    public ResponseEntity<PaymentAuthorizeResponse> initiatePayment(String encryptedPaymentId, String authorisationId, String consentAndaccessTokenCookieString) {
        try {
            String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
            PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndaccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            workflow.getScaResponse().setScaStatus(ScaStatusTO.PSUAUTHENTICATED);
            this.updateAuthorisationStatus(workflow, psuId, this.response);
            this.scaStatus = workflow.getAuthResponse().getScaStatus();
            this.initiatePayment(workflow, this.response);
            this.updateScaStatusPaymentStatusConsentData(psuId, workflow);
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        catch (PaymentAuthorizeException e) {
            return e.getError();
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndaccessTokenCookieString) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndaccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            this.selectMethod(scaMethodId, workflow);
            this.updateScaStatusPaymentStatusConsentData(psuId, workflow);
            this.scaStatus = workflow.getAuthResponse().getScaStatus();
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        catch (PaymentAuthorizeException e) {
            return e.getError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> authrizedPayment(String encryptedPaymentId, String authorisationId, String consentAndaccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndaccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            SCAPaymentResponseTO scaPaymentResponse = (SCAPaymentResponseTO)this.paymentRestClient.authorizePayment(workflow.paymentId(), workflow.authId(), authCode).getBody();
            this.processPaymentResponse(workflow, scaPaymentResponse);
            this.updateScaStatusPaymentStatusConsentData(psuId, workflow);
            this.scaStatus = workflow.getAuthResponse().getScaStatus();
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)workflow.getAuthResponse());
            return responseEntity;
        }
        catch (PaymentAuthorizeException e) {
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> failPaymentAuthorisation(String encryptedPaymentId, String authorisationId, String cookieString) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, cookieString, psuId, this.response, this.auth.getBearerToken());
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            workflow.getScaResponse().setScaStatus(ScaStatusTO.FAILED);
            this.updateAuthorisationStatus(workflow, psuId, this.response);
            this.updateAspspConsentData(workflow, this.response);
            this.responseUtils.removeCookies(this.response);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)workflow.getAuthResponse());
            return responseEntity;
        }
        catch (PaymentAuthorizeException e) {
            this.responseUtils.removeCookies(this.response);
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> pisDone(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, Boolean forgetConsent, Boolean backToTpp) {
        String redirectURL = ScaStatusTO.FINALISED.equals((Object)this.scaStatus) ? this.tppOkRedirectUri : this.tppNokRedirectUri;
        return this.responseUtils.redirect(redirectURL, this.response);
    }

    private void updateScaStatusPaymentStatusConsentData(String psuId, PaymentWorkflow workflow) throws PaymentAuthorizeException {
        SCAResponseTO scaResponse = workflow.getScaResponse();
        if (scaResponse != null && scaResponse.getScaStatus() != ScaStatusTO.EXEMPTED) {
            this.updateAuthorisationStatus(workflow, psuId, this.response);
        }
        this.updatePaymentStatus(this.response, workflow);
        this.updateAspspConsentData(workflow, this.response);
    }

    private void updateAspspConsentData(PaymentWorkflow paymentWorkflow, HttpServletResponse httpResp) throws PaymentAuthorizeException {
        CmsAspspConsentDataBase64 consentData;
        try {
            consentData = new CmsAspspConsentDataBase64(paymentWorkflow.paymentId(), this.tokenStorageService.toBase64String(paymentWorkflow.getScaResponse()));
        }
        catch (IOException e) {
            throw new PaymentAuthorizeException(this.responseUtils.backToSender((OnlineBankingResponse)this.authResp(), paymentWorkflow.getPaymentResponse().getTppNokRedirectUri(), paymentWorkflow.getPaymentResponse().getTppOkRedirectUri(), httpResp, HttpStatus.INTERNAL_SERVER_ERROR, ValidationCode.CONSENT_DATA_UPDATE_FAILED));
        }
        ResponseEntity updateAspspConsentData = this.aspspConsentDataClient.updateAspspConsentData(paymentWorkflow.getConsentReference().getEncryptedConsentId(), consentData);
        if (!HttpStatus.OK.equals((Object)updateAspspConsentData.getStatusCode())) {
            throw new PaymentAuthorizeException(this.responseUtils.backToSender((OnlineBankingResponse)this.authResp(), paymentWorkflow.getPaymentResponse().getTppNokRedirectUri(), paymentWorkflow.getPaymentResponse().getTppOkRedirectUri(), httpResp, updateAspspConsentData.getStatusCode(), ValidationCode.CONSENT_DATA_UPDATE_FAILED));
        }
    }

    PaymentAuthorizeResponse authResp() {
        return new PaymentAuthorizeResponse();
    }

    private void initiatePayment(PaymentWorkflow paymentWorkflow, HttpServletResponse response) throws PaymentAuthorizeException {
        CmsPaymentResponse paymentResponse = paymentWorkflow.getPaymentResponse();
        Object payment = this.convertPayment(response, paymentWorkflow.paymentType(), paymentResponse);
        try {
            this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
            SCAPaymentResponseTO paymentResponseTO = (SCAPaymentResponseTO)this.paymentRestClient.initiatePayment(paymentWorkflow.paymentType(), payment).getBody();
            this.processPaymentResponse(paymentWorkflow, paymentResponseTO);
        }
        catch (FeignException f) {
            paymentWorkflow.setErrorCode(HttpStatus.valueOf((int)f.status()));
            throw f;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private void updatePaymentStatus(HttpServletResponse response, PaymentWorkflow paymentWorkflow) throws PaymentAuthorizeException {
        ResponseEntity updatePaymentStatus = this.cmsPsuPisClient.updatePaymentStatus(paymentWorkflow.getPaymentResponse().getPayment().getPaymentId(), paymentWorkflow.getPaymentStatus(), "UNDEFINED");
        paymentWorkflow.getAuthResponse().updatePaymentStatus(TransactionStatusTO.valueOf((String)paymentWorkflow.getPaymentStatus()));
        if (!HttpStatus.OK.equals((Object)updatePaymentStatus.getStatusCode())) {
            throw new PaymentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), "Could not set payment status. See status code.", updatePaymentStatus.getStatusCode(), response));
        }
    }

    private Object convertPayment(HttpServletResponse response, PaymentTypeTO paymentType, CmsPaymentResponse paymentResponse) throws PaymentAuthorizeException {
        switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$payment$PaymentTypeTO[paymentType.ordinal()]) {
            case 1: {
                return this.singlePaymentMapper.toPayment((CmsSinglePayment)paymentResponse.getPayment());
            }
            case 2: {
                return this.bulkPaymentMapper.toPayment((CmsBulkPayment)paymentResponse.getPayment());
            }
            case 3: {
                return this.periodicPaymentMapper.toPayment((CmsPeriodicPayment)paymentResponse.getPayment());
            }
        }
        throw new PaymentAuthorizeException(this.responseUtils.badRequest((OnlineBankingResponse)this.authResp(), String.format("Payment type %s not supported.", paymentType.name()), response));
    }

    private PaymentWorkflow identifyPayment(String encryptedPaymentId, String authorizationId, boolean strict, String consentCookieString, String psuId, HttpServletResponse response, BearerTokenTO bearerToken) throws PaymentAuthorizeException {
        ConsentReference consentReference = null;
        try {
            String consentCookie = this.responseUtils.consentCookie(consentCookieString);
            consentReference = this.referencePolicy.fromRequest(encryptedPaymentId, authorizationId, consentCookie, strict);
        }
        catch (InvalidConsentException e) {
            throw new PaymentAuthorizeException(this.responseUtils.forbidden((OnlineBankingResponse)this.authResp(), e.getMessage(), response));
        }
        CmsPaymentResponse cmsPaymentResponse = this.loadPaymentByRedirectId(psuId, consentReference, response);
        PaymentWorkflow workflow = new PaymentWorkflow(cmsPaymentResponse, consentReference);
        Object convertedPaymentTO = this.convertPayment(response, workflow.paymentType(), cmsPaymentResponse);
        workflow.setAuthResponse(new PaymentAuthorizeResponse(workflow.paymentType(), convertedPaymentTO));
        workflow.getAuthResponse().setAuthorisationId(cmsPaymentResponse.getAuthorisationId());
        workflow.getAuthResponse().setEncryptedConsentId(encryptedPaymentId);
        if (bearerToken != null) {
            SCAPaymentResponseTO scaPaymentResponseTO = new SCAPaymentResponseTO();
            scaPaymentResponseTO.setBearerToken(bearerToken);
            workflow.setScaResponse((SCAResponseTO)scaPaymentResponseTO);
        }
        return workflow;
    }

    private void updateAuthorisationStatus(PaymentWorkflow workflow, String psuId, HttpServletResponse response) throws PaymentAuthorizeException {
        String status;
        String authorisationId;
        String paymentId = workflow.getPaymentResponse().getPayment().getPaymentId();
        ResponseEntity resp = this.cmsPsuPisClient.updateAuthorisationStatus(psuId, null, null, null, paymentId, authorisationId = workflow.getPaymentResponse().getAuthorisationId(), status = workflow.getAuthResponse().getScaStatus().name(), "UNDEFINED");
        if (resp.getStatusCode() != HttpStatus.OK) {
            throw new PaymentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), "Error updating authorisation status. See error code.", resp.getStatusCode(), response));
        }
    }

    private CmsPaymentResponse loadPaymentByRedirectId(String psuId, ConsentReference consentReference, HttpServletResponse response) throws PaymentAuthorizeException {
        String psuIdType = null;
        String psuCorporateId = null;
        String psuCorporateIdType = null;
        String redirectId = consentReference.getRedirectId();
        ResponseEntity responseEntity = this.cmsPsuPisClient.getPaymentByRedirectId(psuId, psuIdType, psuCorporateId, psuCorporateIdType, redirectId, "UNDEFINED");
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (HttpStatus.OK.equals((Object)statusCode)) {
            return (CmsPaymentResponse)responseEntity.getBody();
        }
        if (HttpStatus.NOT_FOUND.equals((Object)statusCode)) {
            throw new PaymentAuthorizeException(this.responseUtils.requestWithRedNotFound((OnlineBankingResponse)this.authResp(), response));
        }
        if (HttpStatus.REQUEST_TIMEOUT.equals((Object)statusCode)) {
            CmsPaymentResponse payment = (CmsPaymentResponse)responseEntity.getBody();
            String location = StringUtils.isNotBlank((CharSequence)payment.getTppNokRedirectUri()) ? payment.getTppNokRedirectUri() : payment.getTppOkRedirectUri();
            throw new PaymentAuthorizeException(this.responseUtils.redirect(location, response));
        }
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new PaymentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), responseEntity.getStatusCode(), response));
        }
        throw new PaymentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), statusCode, response));
    }

    public String getBasePath() {
        return "/pis";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCAPaymentResponseTO selectMethod(String scaMethodId, PaymentWorkflow workflow) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            SCAPaymentResponseTO paymentResponseTO = (SCAPaymentResponseTO)this.paymentRestClient.selectMethod(workflow.paymentId(), workflow.authId(), scaMethodId).getBody();
            this.processPaymentResponse(workflow, paymentResponseTO);
            SCAPaymentResponseTO sCAPaymentResponseTO = paymentResponseTO;
            return sCAPaymentResponseTO;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private void processPaymentResponse(PaymentWorkflow paymentWorkflow, SCAPaymentResponseTO paymentResponse) {
        this.processSCAResponse(paymentWorkflow, (SCAResponseTO)paymentResponse);
        paymentWorkflow.setPaymentStatus(paymentResponse.getTransactionStatus().name());
    }

    private void processSCAResponse(PaymentWorkflow workflow, SCAResponseTO paymentResponse) {
        workflow.setScaResponse(paymentResponse);
        workflow.getAuthResponse().setAuthorisationId(paymentResponse.getAuthorisationId());
        workflow.getAuthResponse().setScaStatus(paymentResponse.getScaStatus());
        workflow.getAuthResponse().setScaMethods(paymentResponse.getScaMethods());
        workflow.setAuthCodeMessage(paymentResponse.getPsuMessage());
    }
}

