/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AccountRestClient;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.ConsentRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReference;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentType;
import de.adorsys.ledgers.oba.rest.api.consentref.InvalidConsentException;
import de.adorsys.ledgers.oba.rest.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.rest.api.domain.ConsentAuthorizeResponse;
import de.adorsys.ledgers.oba.rest.api.domain.ConsentWorkflow;
import de.adorsys.ledgers.oba.rest.api.domain.CreatePiisConsentRequestTO;
import de.adorsys.ledgers.oba.rest.api.domain.OnlineBankingResponse;
import de.adorsys.ledgers.oba.rest.api.domain.PIISConsentCreateResponse;
import de.adorsys.ledgers.oba.rest.api.domain.ValidationCode;
import de.adorsys.ledgers.oba.rest.api.exception.ConsentAuthorizeException;
import de.adorsys.ledgers.oba.rest.api.resource.AISApi;
import de.adorsys.ledgers.oba.rest.server.auth.MiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.mapper.AisConsentMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.CreatePiisConsentRequestMapper;
import de.adorsys.ledgers.oba.rest.server.resource.AISController;
import de.adorsys.ledgers.oba.rest.server.resource.AbstractXISController;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentAccessRequest;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import feign.FeignException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adorsys.ledgers.consent.aspsp.rest.client.CmsAspspPiisClient;
import org.adorsys.ledgers.consent.aspsp.rest.client.CreatePiisConsentRequest;
import org.adorsys.ledgers.consent.aspsp.rest.client.CreatePiisConsentResponse;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuAisClient;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/ais")
@RequestMapping(value={"/ais"})
@Api(value="/ais", tags={"PSU AIS"}, description="Provides access to online banking account functionality")
public class AISController
extends AbstractXISController
implements AISApi {
    private static final Logger log = LoggerFactory.getLogger(AISController.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private UserMgmtRestClient userMgmtRestClient;
    @Autowired
    private AuthRequestInterceptor authInterceptor;
    @Autowired
    private CmsPsuAisClient cmsPsuAisClient;
    @Autowired
    private AisConsentMapper consentMapper;
    @Autowired
    private ConsentRestClient consentRestClient;
    @Autowired
    private CmsAspspPiisClient cmsAspspPiisClient;
    @Autowired
    private CreatePiisConsentRequestMapper createPiisConsentRequestMapper;
    @Autowired
    private AccountRestClient accountRestClient;
    private ScaStatusTO scaStatus;
    private String tppNokRedirectUri;
    private String tppOkRedirectUri;

    @ApiOperation(value="Entry point for authenticating ais consent requests.")
    public ResponseEntity<AuthorizeResponse> aisAuth(String redirectId, String encryptedConsentId) {
        log.debug("encryptedConsentId: {}", (Object)encryptedConsentId);
        return this.auth(redirectId, ConsentType.AIS, encryptedConsentId, this.request, this.response);
    }

    public String getBasePath() {
        return "/ais";
    }

    public ResponseEntity<ConsentAuthorizeResponse> login(String encryptedConsentId, String authorisationId, String login, String pin, String consentCookieString) {
        ResponseEntity authoriseForConsent;
        ConsentWorkflow workflow;
        try {
            workflow = this.identifyConsent(encryptedConsentId, authorisationId, false, consentCookieString, login, this.response, null);
            log.debug("Login: {}", (Object)login);
            CmsAisConsentResponse consent = workflow.getConsentResponse();
            log.debug("authorisationId: {}", (Object)consent.getAuthorisationId());
            this.tppNokRedirectUri = consent.getTppNokRedirectUri();
            this.tppOkRedirectUri = consent.getTppOkRedirectUri();
            this.scaStatus = ScaStatusTO.RECEIVED;
        }
        catch (ConsentAuthorizeException e) {
            return e.getError();
        }
        try {
            authoriseForConsent = this.userMgmtRestClient.authoriseForConsent(login, pin, workflow.consentId(), workflow.authId(), OpTypeTO.CONSENT);
        }
        catch (FeignException e) {
            if (e.status() == 404 || e.status() == 401) {
                this.responseUtils.setCookies(this.response, workflow.getConsentReference(), null, null);
                return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)workflow.getAuthResponse());
            }
            if (e.status() == 403) {
                try {
                    workflow.getAuthResponse().setScaStatus(ScaStatusTO.PSUIDENTIFIED);
                    log.debug("403 Error: {}", (Object)ScaStatusTO.PSUIDENTIFIED);
                    this.updatePSUIdentification(workflow, login);
                    this.scaStatus(workflow, login, this.response);
                    this.responseUtils.setCookies(this.response, workflow.getConsentReference(), null, null);
                    return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)workflow.getAuthResponse());
                }
                catch (ConsentAuthorizeException e1) {
                    return e1.getError();
                }
            }
            throw e;
        }
        this.storeSCAResponseIntoWorkflow(workflow, (SCAResponseTO)authoriseForConsent.getBody());
        boolean success = AuthUtils.success((ResponseEntity)authoriseForConsent);
        if (success) {
            String psuId = AuthUtils.psuId((BearerTokenTO)workflow.bearerToken());
            try {
                this.updatePSUIdentification(workflow, psuId);
                this.updateScaStatusConsentStatusConsentData(psuId, workflow);
            }
            catch (ConsentAuthorizeException e) {
                return e.getError();
            }
            switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$sca$ScaStatusTO[workflow.scaStatus().ordinal()]) {
                case 1: {
                    this.responseUtils.removeCookies(this.response);
                    return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    List listOfAccounts = this.listOfAccounts(workflow);
                    workflow.getAuthResponse().setAccounts(listOfAccounts);
                    AisAccountAccess consentAccountAccess = workflow.getConsentResponse().getAccountConsent().getAccess();
                    if (this.isConsentGlobal(consentAccountAccess)) {
                        AisAccountAccessInfoTO authAccountAccess = workflow.getAuthResponse().getConsent().getAccess();
                        List ibans = this.extractUserIbans(listOfAccounts);
                        authAccountAccess.setAccounts(ibans);
                        authAccountAccess.setTransactions(ibans);
                        authAccountAccess.setBalances(ibans);
                    }
                    this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
                    return ResponseEntity.ok((Object)workflow.getAuthResponse());
                }
            }
            this.responseUtils.removeCookies(this.response);
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    public ResponseEntity<ConsentAuthorizeResponse> startConsentAuth(String encryptedConsentId, String authorisationId, String consentAndaccessTokenCookieString, AisConsentTO aisConsent) {
        List listOfAccounts;
        ConsentWorkflow workflow;
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            workflow = this.identifyConsent(encryptedConsentId, authorisationId, false, consentAndaccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            listOfAccounts = this.listOfAccounts(workflow);
            this.startConsent(workflow, aisConsent, listOfAccounts);
            this.updateScaStatusConsentStatusConsentData(psuId, workflow);
        }
        catch (ConsentAuthorizeException e) {
            return e.getError();
        }
        this.scaStatus = workflow.getAuthResponse().getScaStatus();
        switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$sca$ScaStatusTO[workflow.scaStatus().ordinal()]) {
            case 1: {
                this.responseUtils.removeCookies(this.response);
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                workflow.getAuthResponse().setAccounts(listOfAccounts);
                this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
                return ResponseEntity.ok((Object)workflow.getAuthResponse());
            }
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<ConsentAuthorizeResponse> authrizedConsent(String encryptedConsentId, String authorisationId, String consentAndaccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            ConsentWorkflow workflow = this.identifyConsent(encryptedConsentId, authorisationId, true, consentAndaccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            SCAConsentResponseTO scaConsentResponse = (SCAConsentResponseTO)this.consentRestClient.authorizeConsent(workflow.consentId(), authorisationId, authCode).getBody();
            this.storeSCAResponseIntoWorkflow(workflow, (SCAResponseTO)scaConsentResponse);
            this.cmsPsuAisClient.confirmConsent(workflow.consentId(), psuId, null, null, null, "UNDEFINED");
            this.updateScaStatusConsentStatusConsentData(psuId, workflow);
            Optional<BearerTokenTO> accessToken = Optional.ofNullable(workflow.bearerToken());
            if (accessToken.isPresent()) {
                this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            } else {
                this.responseUtils.setCookies(this.response, workflow.getConsentReference(), "", null);
            }
            this.scaStatus = workflow.getAuthResponse().getScaStatus();
            ResponseEntity responseEntity = ResponseEntity.ok((Object)workflow.getAuthResponse());
            return responseEntity;
        }
        catch (ConsentAuthorizeException e) {
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<ConsentAuthorizeResponse> selectMethod(String encryptedConsentId, String authorisationId, String scaMethodId, String consentAndaccessTokenCookieString) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            ConsentWorkflow workflow = this.identifyConsent(encryptedConsentId, authorisationId, true, consentAndaccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            this.selectMethod(scaMethodId, workflow);
            this.updateScaStatusConsentStatusConsentData(psuId, workflow);
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            this.scaStatus = workflow.getAuthResponse().getScaStatus();
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        catch (ConsentAuthorizeException e) {
            return e.getError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PIISConsentCreateResponse> grantPiisConsent(String consentAndaccessTokenCookieString, CreatePiisConsentRequestTO piisConsentRequestTO) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            this.authInterceptor.setAccessToken(this.auth.getBearerToken().getAccess_token());
            CreatePiisConsentRequest piisConsentRequest = this.createPiisConsentRequestMapper.fromCreatePiisConsentRequest(piisConsentRequestTO);
            CreatePiisConsentResponse cmsCcnsent = (CreatePiisConsentResponse)this.cmsAspspPiisClient.createConsent(piisConsentRequest, psuId, null, null, null).getBody();
            AisConsentTO pisConsent = new AisConsentTO();
            AisAccountAccessInfoTO access = new AisAccountAccessInfoTO();
            access.setBalances(piisConsentRequest.getAccounts().stream().map(a -> a.getIban()).collect(Collectors.toList()));
            pisConsent.setAccess(access);
            pisConsent.setFrequencyPerDay(piisConsentRequest.getAllowedFrequencyPerDay());
            pisConsent.setId(cmsCcnsent.getConsentId());
            pisConsent.setRecurringIndicator(true);
            pisConsent.setTppId(piisConsentRequest.getTppInfo().getAuthorisationNumber());
            pisConsent.setUserId(psuId);
            pisConsent.setValidUntil(piisConsentRequest.getValidUntil());
            SCAConsentResponseTO scaConsentResponse = (SCAConsentResponseTO)this.consentRestClient.grantPIISConsent(pisConsent).getBody();
            ResponseEntity updateAspspPiisConsentDataResponse = this.updateAspspPiisConsentData(cmsCcnsent.getConsentId(), scaConsentResponse);
            if (!HttpStatus.OK.equals((Object)updateAspspPiisConsentDataResponse.getStatusCode())) {
                ResponseEntity responseEntity = this.responseUtils.error((OnlineBankingResponse)new PIISConsentCreateResponse(), updateAspspPiisConsentDataResponse.getStatusCode(), "Could not update aspsp consent data", this.response);
                return responseEntity;
            }
            this.responseUtils.setCookies(this.response, null, this.auth.getBearerToken().getAccess_token(), this.auth.getBearerToken().getAccessTokenObject());
            AisConsentTO consent = scaConsentResponse.getBearerToken().getAccessTokenObject().getConsent();
            ResponseEntity responseEntity = ResponseEntity.ok((Object)new PIISConsentCreateResponse(consent));
            return responseEntity;
        }
        catch (IOException e) {
            ResponseEntity responseEntity = this.responseUtils.error((OnlineBankingResponse)new PIISConsentCreateResponse(), HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), this.response);
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<List<AccountDetailsTO>> getListOfAccounts(String accessTokenCookieString) {
        try {
            this.authInterceptor.setAccessToken(this.auth.getBearerToken().getAccess_token());
            ResponseEntity listOfAccounts = this.accountRestClient.getListOfAccounts();
            ResponseEntity responseEntity = ResponseEntity.ok((Object)listOfAccounts.getBody());
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<ConsentAuthorizeResponse> aisDone(String encryptedConsentId, String authorisationId, String consentAndAccessTokenCookieString, Boolean forgetConsent, Boolean backToTpp) {
        String redirectURL = ScaStatusTO.FINALISED.equals((Object)this.scaStatus) ? this.tppOkRedirectUri : this.tppNokRedirectUri;
        return this.responseUtils.redirect(redirectURL, this.response);
    }

    public ResponseEntity<ConsentAuthorizeResponse> revokeConsent(@NotNull String encryptedConsentId, @NotNull String authorisationId, String cookieString) {
        ConsentWorkflow workflow;
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            workflow = this.getConsentWorkflow(encryptedConsentId, authorisationId, cookieString, psuId);
        }
        catch (ConsentAuthorizeException e) {
            return ResponseEntity.badRequest().build();
        }
        if (this.failAuthorisation(workflow.encryptedConsentId(), psuId, authorisationId)) {
            return ResponseEntity.ok((Object)this.buildResponseForSuccessfulConsentRevoke());
        }
        return ResponseEntity.badRequest().build();
    }

    private ConsentWorkflow getConsentWorkflow(String encryptedConsentId, String authorisationId, String cookieString, String psuId) throws ConsentAuthorizeException {
        ConsentWorkflow workflow = this.identifyConsent(encryptedConsentId, authorisationId, true, cookieString, psuId, this.response, this.auth.getBearerToken());
        this.authInterceptor.setAccessToken(this.auth.getBearerToken().getAccess_token());
        return workflow;
    }

    private boolean failAuthorisation(String encryptedConsentId, String psuId, String authorisationId) {
        ResponseEntity updateAuthorisationStatusResponse = this.cmsPsuAisClient.updateAuthorisationStatus(encryptedConsentId, "FAILED", authorisationId, psuId, null, null, null, "UNDEFINED");
        return updateAuthorisationStatusResponse.getStatusCode() == HttpStatus.OK;
    }

    private ConsentAuthorizeResponse buildResponseForSuccessfulConsentRevoke() {
        ConsentAuthorizeResponse consentAuthorisationResponse = new ConsentAuthorizeResponse();
        consentAuthorisationResponse.setScaStatus(ScaStatusTO.EXEMPTED);
        consentAuthorisationResponse.setAccounts(Collections.emptyList());
        AisConsentTO consent = new AisConsentTO();
        AisAccountAccessInfoTO access = new AisAccountAccessInfoTO();
        access.setBalances(Collections.emptyList());
        access.setAccounts(Collections.emptyList());
        access.setTransactions(Collections.emptyList());
        consent.setAccess(access);
        consentAuthorisationResponse.setConsent(consent);
        return consentAuthorisationResponse;
    }

    private ConsentWorkflow identifyConsent(String encryptedConsentId, String authorizationId, boolean strict, String consentCookieString, String psuId, HttpServletResponse response, BearerTokenTO bearerToken) throws ConsentAuthorizeException {
        ConsentReference consentReference;
        try {
            String consentCookie = this.responseUtils.consentCookie(consentCookieString);
            consentReference = this.referencePolicy.fromRequest(encryptedConsentId, authorizationId, consentCookie, strict);
        }
        catch (InvalidConsentException e) {
            throw new ConsentAuthorizeException(this.responseUtils.forbidden((OnlineBankingResponse)this.authResp(), e.getMessage(), response));
        }
        CmsAisConsentResponse cmsConsentResponse = this.loadConsentByRedirectId(psuId, consentReference, response);
        ConsentWorkflow workflow = new ConsentWorkflow(cmsConsentResponse, consentReference);
        AisConsentTO aisConsentTO = this.consentMapper.toTo(cmsConsentResponse.getAccountConsent());
        workflow.setAuthResponse(new ConsentAuthorizeResponse(aisConsentTO));
        workflow.getAuthResponse().setAuthorisationId(cmsConsentResponse.getAuthorisationId());
        workflow.getAuthResponse().setEncryptedConsentId(encryptedConsentId);
        if (bearerToken != null) {
            SCAConsentResponseTO scaConsentResponseTO = new SCAConsentResponseTO();
            scaConsentResponseTO.setBearerToken(bearerToken);
            workflow.setScaResponse((SCAResponseTO)scaConsentResponseTO);
        }
        return workflow;
    }

    private void storeSCAResponseIntoWorkflow(ConsentWorkflow workflow, SCAResponseTO consentResponse) {
        workflow.setScaResponse(consentResponse);
        workflow.getAuthResponse().setAuthorisationId(consentResponse.getAuthorisationId());
        workflow.getAuthResponse().setScaStatus(consentResponse.getScaStatus());
        workflow.getAuthResponse().setScaMethods(consentResponse.getScaMethods());
        workflow.setAuthCodeMessage(consentResponse.getPsuMessage());
    }

    private void scaStatus(ConsentWorkflow workflow, String psuId, HttpServletResponse response) throws ConsentAuthorizeException {
        String status = workflow.getAuthResponse().getScaStatus().name();
        ResponseEntity resp = this.cmsPsuAisClient.updateAuthorisationStatus(workflow.consentId(), status, workflow.authId(), psuId, null, null, null, "UNDEFINED");
        if (!HttpStatus.OK.equals((Object)resp.getStatusCode())) {
            throw new ConsentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), "Error updating authorisation status. See error code.", resp.getStatusCode(), response));
        }
    }

    private void updatePSUIdentification(ConsentWorkflow workflow, String psuId) throws ConsentAuthorizeException {
        PsuIdData psuIdData = new PsuIdData(psuId, null, null, null);
        ResponseEntity resp = this.cmsPsuAisClient.updatePsuDataInConsent(workflow.consentId(), workflow.authId(), "UNDEFINED", psuIdData);
        if (!HttpStatus.OK.equals((Object)resp.getStatusCode())) {
            throw new ConsentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), "Error updating psu identification. See error code.", resp.getStatusCode(), this.response));
        }
    }

    private ConsentAuthorizeResponse authResp() {
        return new ConsentAuthorizeResponse();
    }

    private void startConsent(ConsentWorkflow workflow, AisConsentTO aisConsent, List<AccountDetailsTO> listOfAccounts) {
        try {
            AisAccountAccess accountAccess = this.consentMapper.accountAccess(aisConsent.getAccess(), listOfAccounts);
            CmsAisConsentAccessRequest accountAccessRequest = new CmsAisConsentAccessRequest(accountAccess, aisConsent.getValidUntil(), aisConsent.getFrequencyPerDay());
            this.cmsPsuAisClient.putAccountAccessInConsent(workflow.consentId(), accountAccessRequest);
            AisConsentTO consent = this.consentMapper.toTo(workflow.getConsentResponse().getAccountConsent());
            consent.setAccess(aisConsent.getAccess());
            workflow.getAuthResponse().setConsent(consent);
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            SCAConsentResponseTO sca = (SCAConsentResponseTO)this.consentRestClient.startSCA(workflow.consentId(), consent).getBody();
            sca.setBearerToken(workflow.bearerToken());
            this.storeSCAResponseIntoWorkflow(workflow, (SCAResponseTO)sca);
        }
        catch (FeignException f) {
            workflow.setErrorCode(HttpStatus.valueOf((int)f.status()));
            throw f;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCAConsentResponseTO selectMethod(String scaMethodId, ConsentWorkflow workflow) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            BearerTokenTO bearerToken = workflow.bearerToken();
            SCAConsentResponseTO sca = (SCAConsentResponseTO)this.consentRestClient.selectMethod(workflow.consentId(), workflow.authId(), scaMethodId).getBody();
            sca.setBearerToken(bearerToken);
            this.storeSCAResponseIntoWorkflow(workflow, (SCAResponseTO)sca);
            SCAConsentResponseTO sCAConsentResponseTO = sca;
            return sCAConsentResponseTO;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private void updateScaStatusConsentStatusConsentData(String psuId, ConsentWorkflow workflow) throws ConsentAuthorizeException {
        this.scaStatus(workflow, psuId, this.response);
        this.updateAspspConsentData(workflow, this.response);
    }

    private void updateAspspConsentData(ConsentWorkflow workflow, HttpServletResponse httpResp) throws ConsentAuthorizeException {
        CmsAspspConsentDataBase64 consentData;
        try {
            consentData = new CmsAspspConsentDataBase64(workflow.consentId(), this.tokenStorageService.toBase64String(workflow.getScaResponse()));
        }
        catch (IOException e) {
            throw new ConsentAuthorizeException(this.responseUtils.backToSender((OnlineBankingResponse)this.authResp(), workflow.getConsentResponse().getTppNokRedirectUri(), workflow.getConsentResponse().getTppOkRedirectUri(), httpResp, HttpStatus.INTERNAL_SERVER_ERROR, ValidationCode.CONSENT_DATA_UPDATE_FAILED));
        }
        ResponseEntity updateAspspConsentData = this.aspspConsentDataClient.updateAspspConsentData(workflow.getConsentReference().getEncryptedConsentId(), consentData);
        if (!HttpStatus.OK.equals((Object)updateAspspConsentData.getStatusCode())) {
            throw new ConsentAuthorizeException(this.responseUtils.backToSender((OnlineBankingResponse)this.authResp(), workflow.getConsentResponse().getTppNokRedirectUri(), workflow.getConsentResponse().getTppOkRedirectUri(), httpResp, updateAspspConsentData.getStatusCode(), ValidationCode.CONSENT_DATA_UPDATE_FAILED));
        }
    }

    private ResponseEntity<?> updateAspspPiisConsentData(String consentId, SCAConsentResponseTO consentResponse) throws IOException {
        CmsAspspConsentDataBase64 consentData = new CmsAspspConsentDataBase64(consentId, this.tokenStorageService.toBase64String((SCAResponseTO)consentResponse));
        return this.aspspConsentDataClient.updateAspspConsentData(consentId, consentData);
    }

    private CmsAisConsentResponse loadConsentByRedirectId(String psuId, ConsentReference consentReference, HttpServletResponse response) throws ConsentAuthorizeException {
        String psuIdType = null;
        String psuCorporateId = null;
        String psuCorporateIdType = null;
        String redirectId = consentReference.getRedirectId();
        ResponseEntity responseEntity = this.cmsPsuAisClient.getConsentByRedirectId(psuId, psuIdType, psuCorporateId, psuCorporateIdType, redirectId, "UNDEFINED");
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (HttpStatus.OK.equals((Object)statusCode)) {
            return (CmsAisConsentResponse)responseEntity.getBody();
        }
        if (HttpStatus.NOT_FOUND.equals((Object)statusCode)) {
            throw new ConsentAuthorizeException(this.responseUtils.requestWithRedNotFound((OnlineBankingResponse)this.authResp(), response));
        }
        if (HttpStatus.REQUEST_TIMEOUT.equals((Object)statusCode)) {
            CmsAisConsentResponse consent = (CmsAisConsentResponse)responseEntity.getBody();
            String location = StringUtils.isNotBlank((CharSequence)consent.getTppNokRedirectUri()) ? consent.getTppNokRedirectUri() : consent.getTppOkRedirectUri();
            throw new ConsentAuthorizeException(this.responseUtils.redirect(location, response));
        }
        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new ConsentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), responseEntity.getStatusCode(), response));
        }
        throw new ConsentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), statusCode, response));
    }

    private List<AccountDetailsTO> listOfAccounts(ConsentWorkflow workflow) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            List list = (List)this.accountRestClient.getListOfAccounts().getBody();
            return list;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private List<String> extractUserIbans(List<AccountDetailsTO> accounts) {
        return accounts.stream().map(AccountDetailsTO::getIban).collect(Collectors.toList());
    }

    private boolean isConsentGlobal(AisAccountAccess aisAccountAccess) {
        return AisAccountAccessTypeTO.ALL_ACCOUNTS.toString().equals(aisAccountAccess.getAllPsd2());
    }
}

