/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.adorsys.ledgers.oba.rest.server.domain.ObaCmsPeriodicPayment;
import de.adorsys.ledgers.oba.rest.server.domain.ObaCmsSinglePayment;
import de.adorsys.ledgers.oba.rest.server.mapper.CmsPaymentDeserializer;
import de.adorsys.psd2.consent.api.pis.CmsBulkPayment;
import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import java.io.IOException;

public class CmsPaymentDeserializer
extends StdDeserializer<CmsPayment> {
    private static final long serialVersionUID = 158931754435907227L;
    private ObjectMapper mapper;

    public CmsPaymentDeserializer(ObjectMapper mapper) {
        super(CmsPayment.class);
        this.mapper = mapper;
    }

    public CmsPayment deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String paymentTypeValue = node.get("paymentType").asText();
        PaymentType paymentType = (PaymentType)PaymentType.getByValue((String)paymentTypeValue).orElseThrow(() -> new IllegalStateException(String.format("Unknown payment type %s", paymentTypeValue)));
        switch (1.$SwitchMap$de$adorsys$psd2$xs2a$core$profile$PaymentType[paymentType.ordinal()]) {
            case 1: {
                return (CmsPayment)this.mapper.convertValue((Object)node, ObaCmsSinglePayment.class);
            }
            case 2: {
                return (CmsPayment)this.mapper.convertValue((Object)node, CmsBulkPayment.class);
            }
            case 3: {
                return (CmsPayment)this.mapper.convertValue((Object)node, ObaCmsPeriodicPayment.class);
            }
        }
        throw new IllegalStateException(String.format("Unknown payment type %s", paymentType.name()));
    }
}

