/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.rest.api.domain.PsuMessage;
import de.adorsys.ledgers.oba.rest.api.domain.PsuMessageCategory;
import de.adorsys.ledgers.oba.rest.api.resource.SCAApi;
import de.adorsys.ledgers.oba.rest.server.auth.MiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.rest.server.resource.SCAController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/sca")
@RequestMapping(value={"/sca"})
@Api(value="/sca", tags={"PSU SCA"}, description="Provides access to one time password for strong customer authentication.")
public class SCAController
implements SCAApi {
    public static final String BASE_PATH = "/sca";
    @Autowired
    private UserMgmtRestClient ledgersUserMgmt;
    @Autowired
    private ResponseUtils responseUtils;
    @Autowired
    private AuthRequestInterceptor authInterceptor;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private MiddlewareAuthentication auth;

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<AuthorizeResponse> login(String login, String pin) {
        SCALoginResponseTO loginResponse = (SCALoginResponseTO)this.ledgersUserMgmt.authorise(login, pin, UserRoleTO.CUSTOMER).getBody();
        AuthorizeResponse authResponse = new AuthorizeResponse();
        ScaStatusTO scaStatus = this.prepareAuthResponse(authResponse, loginResponse);
        BearerTokenTO bearerToken = loginResponse.getBearerToken();
        switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$sca$ScaStatusTO[scaStatus.ordinal()]) {
            case 1: {
                authResponse.setScaMethods(loginResponse.getScaMethods());
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.responseUtils.setCookies(this.response, null, bearerToken.getAccess_token(), bearerToken.getAccessTokenObject());
                return ResponseEntity.ok((Object)authResponse);
            }
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    private ScaStatusTO prepareAuthResponse(AuthorizeResponse authResponse, SCALoginResponseTO loginResponse) {
        ScaStatusTO scaStatus = loginResponse.getScaStatus();
        authResponse.setScaStatus(scaStatus);
        authResponse.setAuthorisationId(loginResponse.getAuthorisationId());
        authResponse.setEncryptedConsentId(loginResponse.getScaId());
        PsuMessage psuMessage = new PsuMessage().category(PsuMessageCategory.INFO).text(loginResponse.getPsuMessage());
        authResponse.setPsuMessages(Arrays.asList(psuMessage));
        return scaStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<AuthorizeResponse> selectMethod(String scaId, String authorisationId, String methodId, String cookies) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        authResponse.setEncryptedConsentId(scaId);
        authResponse.setAuthorisationId(authorisationId);
        try {
            this.authInterceptor.setAccessToken(this.auth.getBearerToken().getAccess_token());
            SCALoginResponseTO loginResponse = (SCALoginResponseTO)this.ledgersUserMgmt.selectMethod(scaId, authorisationId, methodId).getBody();
            this.prepareAuthResponse(authResponse, loginResponse);
            BearerTokenTO bearerToken = loginResponse.getBearerToken();
            this.responseUtils.setCookies(this.response, null, bearerToken.getAccess_token(), bearerToken.getAccessTokenObject());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authResponse);
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<AuthorizeResponse> validateAuthCode(String scaId, String authorisationId, String authCode, String cookies) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        authResponse.setEncryptedConsentId(scaId);
        authResponse.setAuthorisationId(authorisationId);
        try {
            this.authInterceptor.setAccessToken(this.auth.getBearerToken().getAccess_token());
            SCALoginResponseTO loginResponse = (SCALoginResponseTO)this.ledgersUserMgmt.authorizeLogin(scaId, authorisationId, authCode).getBody();
            this.prepareAuthResponse(authResponse, loginResponse);
            BearerTokenTO bearerToken = loginResponse.getBearerToken();
            this.responseUtils.setCookies(this.response, null, bearerToken.getAccess_token(), bearerToken.getAccessTokenObject());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)authResponse);
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }
}

