/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReference;
import de.adorsys.ledgers.oba.rest.api.consentref.InvalidConsentException;
import de.adorsys.ledgers.oba.rest.api.domain.OnlineBankingResponse;
import de.adorsys.ledgers.oba.rest.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.rest.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.rest.api.domain.ValidationCode;
import de.adorsys.ledgers.oba.rest.api.exception.PaymentAuthorizeException;
import de.adorsys.ledgers.oba.rest.api.resource.PisCancellationApi;
import de.adorsys.ledgers.oba.rest.server.auth.MiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.mapper.BulkPaymentMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.PeriodicPaymentMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.SinglePaymentMapper;
import de.adorsys.ledgers.oba.rest.server.resource.AbstractXISController;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.PisCancellationController;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.pis.CmsBulkPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.api.pis.CmsPeriodicPayment;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import feign.FeignException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuPisClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/pis-cancellation")
@RequestMapping(value={"/pis-cancellation"})
@Api(value="/pis-cancellation", tags={"PSU PIS Cancellation"}, description="Provides access to online banking payment functionality")
public class PisCancellationController
extends AbstractXISController
implements PisCancellationApi {
    @Autowired
    private CmsPsuPisClient cmsPsuPisClient;
    @Autowired
    private PaymentRestClient paymentRestClient;
    @Autowired
    private UserMgmtRestClient userMgmtRestClient;
    @Autowired
    private SinglePaymentMapper singlePaymentMapper;
    @Autowired
    private BulkPaymentMapper bulkPaymentMapper;
    @Autowired
    private PeriodicPaymentMapper periodicPaymentMapper;
    private ScaStatusTO scaStatus;
    private String tppNokRedirectUri;
    private String tppOkRedirectUri;

    @ApiOperation(value="Identifies the user by login an pin. Return sca methods information")
    public ResponseEntity<PaymentAuthorizeResponse> login(String encryptedPaymentId, String authorisationId, String login, String pin, String consentCookieString) {
        PaymentWorkflow cancellationWorkflow;
        try {
            cancellationWorkflow = this.identifyPayment(encryptedPaymentId, authorisationId, false, consentCookieString, login, this.response, null);
            CmsPaymentResponse payment = cancellationWorkflow.getPaymentResponse();
            this.tppNokRedirectUri = payment.getTppNokRedirectUri();
            this.tppOkRedirectUri = payment.getTppOkRedirectUri();
            this.scaStatus = ScaStatusTO.RECEIVED;
        }
        catch (PaymentAuthorizeException e) {
            return e.getError();
        }
        ResponseEntity authoriseForConsent = this.userMgmtRestClient.authoriseForConsent(login, pin, cancellationWorkflow.paymentId(), cancellationWorkflow.authId(), OpTypeTO.PAYMENT);
        this.processSCAResponse(cancellationWorkflow, (SCAResponseTO)authoriseForConsent.getBody());
        boolean success = AuthUtils.success((ResponseEntity)authoriseForConsent);
        if (success) {
            String psuId = AuthUtils.psuId((BearerTokenTO)cancellationWorkflow.bearerToken());
            try {
                this.updateAuthorisationStatus(cancellationWorkflow, psuId, this.response);
                this.initiateCancelPayment(cancellationWorkflow);
                if (cancellationWorkflow.singleScaMethod()) {
                    ScaUserDataTO scaUserDataTO = (ScaUserDataTO)cancellationWorkflow.scaMethods().iterator().next();
                    this.selectMethod(scaUserDataTO.getId(), cancellationWorkflow);
                }
                this.updateScaStatusPaymentStatusConsentData(psuId, cancellationWorkflow);
            }
            catch (PaymentAuthorizeException e) {
                return e.getError();
            }
            switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$sca$ScaStatusTO[cancellationWorkflow.scaStatus().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.responseUtils.setCookies(this.response, cancellationWorkflow.getConsentReference(), cancellationWorkflow.bearerToken().getAccess_token(), cancellationWorkflow.bearerToken().getAccessTokenObject());
                    return ResponseEntity.ok((Object)cancellationWorkflow.getAuthResponse());
                }
            }
            this.responseUtils.removeCookies(this.response);
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndAccessTokenCookieString) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            PaymentWorkflow cancellationWorkflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndAccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            this.selectMethod(scaMethodId, cancellationWorkflow);
            this.updateScaStatusPaymentStatusConsentData(psuId, cancellationWorkflow);
            this.scaStatus = cancellationWorkflow.getAuthResponse().getScaStatus();
            this.responseUtils.setCookies(this.response, cancellationWorkflow.getConsentReference(), cancellationWorkflow.bearerToken().getAccess_token(), cancellationWorkflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)cancellationWorkflow.getAuthResponse());
        }
        catch (PaymentAuthorizeException e) {
            return e.getError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<PaymentAuthorizeResponse> authorisePayment(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, String authCode) {
        String psuId = AuthUtils.psuId((MiddlewareAuthentication)this.auth);
        try {
            PaymentWorkflow cancellationWorkflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndAccessTokenCookieString, psuId, this.response, this.auth.getBearerToken());
            this.authInterceptor.setAccessToken(cancellationWorkflow.bearerToken().getAccess_token());
            SCAPaymentResponseTO scaPaymentResponse = (SCAPaymentResponseTO)this.paymentRestClient.authorizeCancelPayment(cancellationWorkflow.paymentId(), cancellationWorkflow.authId(), authCode).getBody();
            this.processPaymentResponse(cancellationWorkflow, scaPaymentResponse);
            cancellationWorkflow.setPaymentStatus(TransactionStatusTO.CANC.toString());
            this.updateScaStatusPaymentStatusConsentData(psuId, cancellationWorkflow);
            this.scaStatus = cancellationWorkflow.getAuthResponse().getScaStatus();
            this.responseUtils.setCookies(this.response, cancellationWorkflow.getConsentReference(), cancellationWorkflow.bearerToken().getAccess_token(), cancellationWorkflow.bearerToken().getAccessTokenObject());
            ResponseEntity responseEntity = ResponseEntity.ok((Object)cancellationWorkflow.getAuthResponse());
            return responseEntity;
        }
        catch (PaymentAuthorizeException e) {
            ResponseEntity responseEntity = e.getError();
            return responseEntity;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ResponseEntity<PaymentAuthorizeResponse> pisDone(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, Boolean forgetConsent, Boolean backToTpp) {
        String redirectURL = ScaStatusTO.FINALISED.equals((Object)this.scaStatus) ? this.tppOkRedirectUri : this.tppNokRedirectUri;
        return this.responseUtils.redirect(redirectURL, this.response);
    }

    private void initiateCancelPayment(PaymentWorkflow paymentWorkflow) {
        try {
            this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
            SCAPaymentResponseTO paymentResponseTO = (SCAPaymentResponseTO)this.paymentRestClient.initiatePmtCancellation(paymentWorkflow.paymentId()).getBody();
            this.processPaymentResponse(paymentWorkflow, paymentResponseTO);
        }
        catch (FeignException f) {
            paymentWorkflow.setErrorCode(HttpStatus.valueOf((int)f.status()));
            throw f;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private void updateScaStatusPaymentStatusConsentData(String psuId, PaymentWorkflow cancellationWorkflow) throws PaymentAuthorizeException {
        this.updateAuthorisationStatus(cancellationWorkflow, psuId, this.response);
        this.updateCmsPaymentStatus(this.response, cancellationWorkflow);
        this.updateAspspConsentData(cancellationWorkflow, this.response);
    }

    private void updateAspspConsentData(PaymentWorkflow paymentWorkflow, HttpServletResponse httpResp) throws PaymentAuthorizeException {
        CmsAspspConsentDataBase64 consentData;
        try {
            consentData = new CmsAspspConsentDataBase64(paymentWorkflow.paymentId(), this.tokenStorageService.toBase64String(paymentWorkflow.getScaResponse()));
        }
        catch (IOException e) {
            throw new PaymentAuthorizeException(this.responseUtils.backToSender((OnlineBankingResponse)this.authResp(), paymentWorkflow.getPaymentResponse().getTppNokRedirectUri(), paymentWorkflow.getPaymentResponse().getTppOkRedirectUri(), httpResp, HttpStatus.INTERNAL_SERVER_ERROR, ValidationCode.CONSENT_DATA_UPDATE_FAILED));
        }
        ResponseEntity updateAspspConsentDataResponse = this.aspspConsentDataClient.updateAspspConsentData(paymentWorkflow.getConsentReference().getEncryptedConsentId(), consentData);
        if (updateAspspConsentDataResponse.getStatusCode() != HttpStatus.OK) {
            throw new PaymentAuthorizeException(this.responseUtils.backToSender((OnlineBankingResponse)this.authResp(), paymentWorkflow.getPaymentResponse().getTppNokRedirectUri(), paymentWorkflow.getPaymentResponse().getTppOkRedirectUri(), httpResp, updateAspspConsentDataResponse.getStatusCode(), ValidationCode.CONSENT_DATA_UPDATE_FAILED));
        }
    }

    PaymentAuthorizeResponse authResp() {
        return new PaymentAuthorizeResponse();
    }

    private void updateCmsPaymentStatus(HttpServletResponse response, PaymentWorkflow paymentWorkflow) throws PaymentAuthorizeException {
        ResponseEntity updatePaymentStatusResponse = this.cmsPsuPisClient.updatePaymentStatus(paymentWorkflow.getPaymentResponse().getPayment().getPaymentId(), paymentWorkflow.getPaymentStatus(), "UNDEFINED");
        paymentWorkflow.getAuthResponse().updatePaymentStatus(TransactionStatusTO.valueOf((String)paymentWorkflow.getPaymentStatus()));
        if (updatePaymentStatusResponse.getStatusCode() != HttpStatus.OK) {
            throw new PaymentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), "Could not set payment status. See status code.", updatePaymentStatusResponse.getStatusCode(), response));
        }
    }

    private Object convertPayment(HttpServletResponse response, PaymentTypeTO paymentType, CmsPaymentResponse paymentResponse) throws PaymentAuthorizeException {
        switch (1.$SwitchMap$de$adorsys$ledgers$middleware$api$domain$payment$PaymentTypeTO[paymentType.ordinal()]) {
            case 1: {
                return this.singlePaymentMapper.toPayment((CmsSinglePayment)paymentResponse.getPayment());
            }
            case 2: {
                return this.bulkPaymentMapper.toPayment((CmsBulkPayment)paymentResponse.getPayment());
            }
            case 3: {
                return this.periodicPaymentMapper.toPayment((CmsPeriodicPayment)paymentResponse.getPayment());
            }
        }
        throw new PaymentAuthorizeException(this.responseUtils.badRequest((OnlineBankingResponse)this.authResp(), String.format("Payment type %s not supported.", paymentType.name()), response));
    }

    private PaymentWorkflow identifyPayment(String encryptedPaymentId, String authorizationId, boolean strict, String consentCookieString, String psuId, HttpServletResponse response, BearerTokenTO bearerToken) throws PaymentAuthorizeException {
        ConsentReference consentReference = null;
        try {
            String consentCookie = this.responseUtils.consentCookie(consentCookieString);
            consentReference = this.referencePolicy.fromRequest(encryptedPaymentId, authorizationId, consentCookie, strict);
        }
        catch (InvalidConsentException e) {
            throw new PaymentAuthorizeException(this.responseUtils.forbidden((OnlineBankingResponse)this.authResp(), e.getMessage(), response));
        }
        CmsPaymentResponse cmsPaymentResponse = this.loadPaymentByRedirectId(psuId, consentReference, response);
        PaymentWorkflow cancellationWorkflow = new PaymentWorkflow(cmsPaymentResponse, consentReference);
        Object convertedPaymentTO = this.convertPayment(response, cancellationWorkflow.paymentType(), cmsPaymentResponse);
        cancellationWorkflow.setAuthResponse(new PaymentAuthorizeResponse(cancellationWorkflow.paymentType(), convertedPaymentTO));
        cancellationWorkflow.getAuthResponse().setAuthorisationId(cmsPaymentResponse.getAuthorisationId());
        cancellationWorkflow.getAuthResponse().setEncryptedConsentId(encryptedPaymentId);
        if (bearerToken != null) {
            SCAPaymentResponseTO scaPaymentResponseTO = new SCAPaymentResponseTO();
            scaPaymentResponseTO.setBearerToken(bearerToken);
            cancellationWorkflow.setScaResponse((SCAResponseTO)scaPaymentResponseTO);
        }
        return cancellationWorkflow;
    }

    private void updateAuthorisationStatus(PaymentWorkflow cancellationWorkflow, String psuId, HttpServletResponse response) throws PaymentAuthorizeException {
        String status;
        String authorisationId;
        String paymentId = cancellationWorkflow.getPaymentResponse().getPayment().getPaymentId();
        ResponseEntity cmsResponse = this.cmsPsuPisClient.updateAuthorisationStatus(psuId, null, null, null, paymentId, authorisationId = cancellationWorkflow.getPaymentResponse().getAuthorisationId(), status = cancellationWorkflow.getAuthResponse().getScaStatus().name(), "UNDEFINED");
        if (cmsResponse.getStatusCode() != HttpStatus.OK) {
            throw new PaymentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), "Error updating authorisation status. See error code.", cmsResponse.getStatusCode(), response));
        }
    }

    private CmsPaymentResponse loadPaymentByRedirectId(String psuId, ConsentReference consentReference, HttpServletResponse response) throws PaymentAuthorizeException {
        ResponseEntity responseEntity = this.cmsPsuPisClient.getPaymentByRedirectIdForCancellation(psuId, null, null, null, consentReference.getRedirectId(), "UNDEFINED");
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode == HttpStatus.OK) {
            return (CmsPaymentResponse)responseEntity.getBody();
        }
        if (statusCode == HttpStatus.NOT_FOUND) {
            throw new PaymentAuthorizeException(this.responseUtils.requestWithRedNotFound((OnlineBankingResponse)this.authResp(), response));
        }
        if (statusCode == HttpStatus.REQUEST_TIMEOUT) {
            CmsPaymentResponse payment = (CmsPaymentResponse)responseEntity.getBody();
            String location = StringUtils.isNotBlank((CharSequence)payment.getTppNokRedirectUri()) ? payment.getTppNokRedirectUri() : payment.getTppOkRedirectUri();
            throw new PaymentAuthorizeException(this.responseUtils.redirect(location, response));
        }
        throw new PaymentAuthorizeException(this.responseUtils.couldNotProcessRequest((OnlineBankingResponse)this.authResp(), statusCode, response));
    }

    public String getBasePath() {
        return "/pis-cancellation";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCAPaymentResponseTO selectMethod(String scaMethodId, PaymentWorkflow cancellationWorkflow) {
        try {
            this.authInterceptor.setAccessToken(cancellationWorkflow.bearerToken().getAccess_token());
            SCAPaymentResponseTO paymentResponseTO = (SCAPaymentResponseTO)this.paymentRestClient.selecCancelPaymentSCAtMethod(cancellationWorkflow.paymentId(), cancellationWorkflow.authId(), scaMethodId).getBody();
            this.processPaymentResponse(cancellationWorkflow, paymentResponseTO);
            SCAPaymentResponseTO sCAPaymentResponseTO = paymentResponseTO;
            return sCAPaymentResponseTO;
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private void processPaymentResponse(PaymentWorkflow paymentWorkflow, SCAPaymentResponseTO paymentResponse) {
        this.processSCAResponse(paymentWorkflow, (SCAResponseTO)paymentResponse);
        paymentWorkflow.setPaymentStatus(paymentResponse.getTransactionStatus().name());
    }

    private void processSCAResponse(PaymentWorkflow cancellationWorkflow, SCAResponseTO paymentResponse) {
        cancellationWorkflow.setScaResponse(paymentResponse);
        cancellationWorkflow.getAuthResponse().setAuthorisationId(paymentResponse.getAuthorisationId());
        cancellationWorkflow.getAuthResponse().setScaStatus(paymentResponse.getScaStatus());
        cancellationWorkflow.getAuthResponse().setScaMethods(paymentResponse.getScaMethods());
        cancellationWorkflow.setAuthCodeMessage(paymentResponse.getPsuMessage());
    }
}

