/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReference;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReferencePolicy;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentType;
import de.adorsys.ledgers.oba.rest.api.consentref.InvalidConsentException;
import de.adorsys.ledgers.oba.rest.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.rest.api.domain.OnlineBankingResponse;
import de.adorsys.ledgers.oba.rest.server.auth.MiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adorsys.ledgers.consent.xs2a.rest.client.AspspConsentDataClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractXISController {
    private static final Logger log = LoggerFactory.getLogger(AbstractXISController.class);
    @Autowired
    protected AspspConsentDataClient aspspConsentDataClient;
    @Autowired
    protected TokenStorageService tokenStorageService;
    @Autowired
    protected AuthRequestInterceptor authInterceptor;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired
    protected MiddlewareAuthentication auth;
    @Value(value="${online-banking.sca.loginpage:http://localhost:4400/}")
    private String loginPage;
    @Autowired
    protected ConsentReferencePolicy referencePolicy;
    @Autowired
    protected ResponseUtils responseUtils;

    public abstract String getBasePath();

    protected ResponseEntity<AuthorizeResponse> auth(String redirectId, ConsentType consentType, String encryptedConsentId, HttpServletRequest request, HttpServletResponse response) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        try {
            ConsentReference consentReference = this.referencePolicy.fromURL(redirectId, consentType, encryptedConsentId);
            authResponse.setEncryptedConsentId(encryptedConsentId);
            authResponse.setAuthorisationId(redirectId);
            this.responseUtils.setCookies(response, consentReference, null, null);
        }
        catch (InvalidConsentException e) {
            log.info(e.getMessage());
            this.responseUtils.removeCookies(response);
            return this.responseUtils.unknownCredentials((OnlineBankingResponse)authResponse, response);
        }
        String uriString = UriComponentsBuilder.fromUriString((String)this.loginPage).queryParam("encryptedConsentId", new Object[]{authResponse.getEncryptedConsentId()}).queryParam("authorisationId", new Object[]{authResponse.getAuthorisationId()}).build().toUriString();
        response.addHeader("Location", uriString);
        return ResponseEntity.ok((Object)authResponse);
    }
}

