/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.oba.rest.server.mapper.PeriodicPaymentMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.PeriodicPaymentMapperImpl;
import de.adorsys.ledgers.oba.rest.server.mapper.ProductTOMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.TimeMapper;
import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.ais.CmsAccountReference;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsFrequencyCode;
import de.adorsys.psd2.consent.api.pis.CmsPeriodicPayment;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeriodicPaymentMapperImpl
implements PeriodicPaymentMapper {
    @Autowired
    private TimeMapper timeMapper;

    public PeriodicPaymentTO toPayment(CmsPeriodicPayment payment) {
        if (payment == null) {
            return null;
        }
        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();
        periodicPaymentTO.setPaymentId(payment.getPaymentId());
        periodicPaymentTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodicPaymentTO.setDebtorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        periodicPaymentTO.setInstructedAmount(this.cmsAmountToAmountTO(payment.getInstructedAmount()));
        periodicPaymentTO.setCreditorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getCreditorAccount()));
        periodicPaymentTO.setCreditorAgent(payment.getCreditorAgent());
        periodicPaymentTO.setCreditorName(payment.getCreditorName());
        periodicPaymentTO.setCreditorAddress(this.cmsAddressToAddressTO(payment.getCreditorAddress()));
        periodicPaymentTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodicPaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        periodicPaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        periodicPaymentTO.setRequestedExecutionTime(this.timeMapper.map(payment.getRequestedExecutionTime()));
        periodicPaymentTO.setStartDate(payment.getStartDate());
        periodicPaymentTO.setEndDate(payment.getEndDate());
        periodicPaymentTO.setFrequency(this.cmsFrequencyCodeToFrequencyCodeTO(payment.getFrequency()));
        periodicPaymentTO.setExecutionRule(this.mapPisExecutionRule(payment.getExecutionRule()));
        periodicPaymentTO.setPaymentProduct(ProductTOMapper.map((String)payment.getPaymentProduct()));
        periodicPaymentTO.setDayOfExecution(Integer.valueOf(this.mapPisDayOfExecution(payment.getDayOfExecution())));
        return periodicPaymentTO;
    }

    protected AccountReferenceTO cmsAccountReferenceToAccountReferenceTO(CmsAccountReference cmsAccountReference) {
        if (cmsAccountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(cmsAccountReference.getIban());
        accountReferenceTO.setBban(cmsAccountReference.getBban());
        accountReferenceTO.setPan(cmsAccountReference.getPan());
        accountReferenceTO.setMaskedPan(cmsAccountReference.getMaskedPan());
        accountReferenceTO.setMsisdn(cmsAccountReference.getMsisdn());
        accountReferenceTO.setCurrency(cmsAccountReference.getCurrency());
        return accountReferenceTO;
    }

    protected AmountTO cmsAmountToAmountTO(CmsAmount cmsAmount) {
        if (cmsAmount == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(cmsAmount.getCurrency());
        amountTO.setAmount(cmsAmount.getAmount());
        return amountTO;
    }

    protected AddressTO cmsAddressToAddressTO(CmsAddress cmsAddress) {
        if (cmsAddress == null) {
            return null;
        }
        AddressTO addressTO = new AddressTO();
        addressTO.setStreet(cmsAddress.getStreet());
        addressTO.setBuildingNumber(cmsAddress.getBuildingNumber());
        addressTO.setCity(cmsAddress.getCity());
        addressTO.setPostalCode(cmsAddress.getPostalCode());
        addressTO.setCountry(cmsAddress.getCountry());
        return addressTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        TransactionStatusTO transactionStatusTO;
        if (transactionStatus == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$xs2a$core$pis$TransactionStatus[transactionStatus.ordinal()]) {
            case 1: {
                transactionStatusTO = TransactionStatusTO.ACCC;
                break;
            }
            case 2: {
                transactionStatusTO = TransactionStatusTO.ACCP;
                break;
            }
            case 3: {
                transactionStatusTO = TransactionStatusTO.ACSC;
                break;
            }
            case 4: {
                transactionStatusTO = TransactionStatusTO.ACSP;
                break;
            }
            case 5: {
                transactionStatusTO = TransactionStatusTO.ACTC;
                break;
            }
            case 6: {
                transactionStatusTO = TransactionStatusTO.ACWC;
                break;
            }
            case 7: {
                transactionStatusTO = TransactionStatusTO.ACWP;
                break;
            }
            case 8: {
                transactionStatusTO = TransactionStatusTO.RCVD;
                break;
            }
            case 9: {
                transactionStatusTO = TransactionStatusTO.PDNG;
                break;
            }
            case 10: {
                transactionStatusTO = TransactionStatusTO.RJCT;
                break;
            }
            case 11: {
                transactionStatusTO = TransactionStatusTO.CANC;
                break;
            }
            case 12: {
                transactionStatusTO = TransactionStatusTO.ACFC;
                break;
            }
            case 13: {
                transactionStatusTO = TransactionStatusTO.PATC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + transactionStatus);
            }
        }
        return transactionStatusTO;
    }

    protected FrequencyCodeTO cmsFrequencyCodeToFrequencyCodeTO(CmsFrequencyCode cmsFrequencyCode) {
        FrequencyCodeTO frequencyCodeTO;
        if (cmsFrequencyCode == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$consent$api$pis$CmsFrequencyCode[cmsFrequencyCode.ordinal()]) {
            case 1: {
                frequencyCodeTO = FrequencyCodeTO.DAILY;
                break;
            }
            case 2: {
                frequencyCodeTO = FrequencyCodeTO.WEEKLY;
                break;
            }
            case 3: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
                break;
            }
            case 4: {
                frequencyCodeTO = FrequencyCodeTO.MONTHLY;
                break;
            }
            case 5: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
                break;
            }
            case 6: {
                frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
                break;
            }
            case 7: {
                frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
                break;
            }
            case 8: {
                frequencyCodeTO = FrequencyCodeTO.ANNUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + cmsFrequencyCode);
            }
        }
        return frequencyCodeTO;
    }
}

