/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.oba.rest.server.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapper {
    public AisConsentTO toTo(AisAccountConsent consent) {
        AisConsentTO a = new AisConsentTO();
        a.setId(consent.getId());
        a.setUserId(this.resolveUserId(consent.getPsuIdDataList()));
        a.setTppId((String)Optional.ofNullable(consent.getTppInfo()).map(TppInfo::getAuthorisationNumber).orElse(null));
        a.setFrequencyPerDay(consent.getFrequencyPerDay());
        a.setAccess(this.toAccess(consent));
        a.setValidUntil(consent.getValidUntil());
        a.setRecurringIndicator(consent.isRecurringIndicator());
        return a;
    }

    public AisAccountAccess accountAccess(AisAccountAccessInfoTO access, List<AccountDetailsTO> accountDetails) {
        List accounts = this.mapToAccountReference(access.getAccounts(), accountDetails);
        List balances = this.mapToAccountReference(access.getBalances(), accountDetails);
        List transactions = this.mapToAccountReference(access.getTransactions(), accountDetails);
        String availableAccounts = access.getAvailableAccounts() != null ? access.getAvailableAccounts().name() : null;
        String allPsd2 = access.getAllPsd2() != null ? access.getAllPsd2().name() : null;
        return new AisAccountAccess(accounts, balances, transactions, availableAccounts, allPsd2);
    }

    private List<AccountReference> mapToAccountReference(List<String> ibans, List<AccountDetailsTO> accountDetails) {
        return ibans == null ? null : ibans.stream().map(iban -> this.toAccountReference(iban, accountDetails)).collect(Collectors.toList());
    }

    private AccountReference toAccountReference(String iban, List<AccountDetailsTO> accountDetails) {
        return accountDetails.stream().filter(a -> a.getIban().equals(iban)).findFirst().map(arg_0 -> this.accountDetail2Reference(arg_0)).orElse(null);
    }

    private AccountReference accountDetail2Reference(AccountDetailsTO ad) {
        AccountReference a = new AccountReference();
        a.setAspspAccountId(ad.getId());
        a.setBban(ad.getBban());
        a.setCurrency(ad.getCurrency());
        a.setIban(ad.getIban());
        a.setMaskedPan(ad.getMaskedPan());
        a.setMsisdn(ad.getMsisdn());
        a.setPan(ad.getPan());
        return a;
    }

    private String resolveUserId(List<PsuIdData> psuIdDataList) {
        if (CollectionUtils.isEmpty(psuIdDataList)) {
            return null;
        }
        return this.getFirstPsu(psuIdDataList).getPsuId();
    }

    private PsuIdData getFirstPsu(List<PsuIdData> psuIdDataList) {
        return psuIdDataList.get(0);
    }

    private AisAccountAccessInfoTO toAccess(AisAccountConsent consent) {
        if (consent.getAccess() == null) {
            return null;
        }
        AisAccountAccess access = consent.getAccess();
        AisAccountAccessInfoTO a = new AisAccountAccessInfoTO();
        a.setAccounts(this.getIbansFromAccountReference(access.getAccounts()));
        a.setBalances(this.getIbansFromAccountReference(access.getBalances()));
        a.setTransactions(this.getIbansFromAccountReference(access.getTransactions()));
        AisConsentRequestType aisConsentRequestType = consent.getAisConsentRequestType();
        boolean withBalance = consent.isWithBalance();
        if (aisConsentRequestType != null) {
            switch (1.$SwitchMap$de$adorsys$psd2$xs2a$core$consent$AisConsentRequestType[aisConsentRequestType.ordinal()]) {
                case 1: {
                    if (withBalance) {
                        a.setAvailableAccounts(AisAccountAccessTypeTO.ALL_ACCOUNTS_WITH_BALANCES);
                        break;
                    }
                    a.setAvailableAccounts(AisAccountAccessTypeTO.ALL_ACCOUNTS);
                    break;
                }
                default: {
                    if (withBalance) {
                        a.setAllPsd2(AisAccountAccessTypeTO.ALL_ACCOUNTS_WITH_BALANCES);
                        break;
                    }
                    a.setAllPsd2(AisAccountAccessTypeTO.ALL_ACCOUNTS);
                }
            }
        }
        return a;
    }

    private List<String> getIbansFromAccountReference(List<AccountReference> references) {
        return Optional.ofNullable(references).map(arg_0 -> this.mapAccountReferencesToString(arg_0)).orElse(null);
    }

    private List<String> mapAccountReferencesToString(List<AccountReference> references) {
        return references.stream().map(AccountReference::getIban).collect(Collectors.toList());
    }
}

