/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.config;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.oba.rest.server.auth.JWTAuthenticationFilter;
import de.adorsys.ledgers.oba.rest.server.auth.MiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.auth.TokenAuthenticationService;
import java.security.Principal;
import java.util.Optional;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.context.annotation.RequestScope;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String[] SWAGGER_WHITELIST = new String[]{"/swagger-resources/**", "/swagger-resources", "/swagger-ui.html**", "/v2/api-docs", "/webjars/**", "favicon.ico", "/error"};
    private static final String[] APP_INDEX_WHITELIST = new String[]{"/", "/index.css", "/img/*", "/favicon.ico"};
    private static final String[] APP_SCA_WHITELIST = new String[]{"/sca/login", "/pis/auth/**", "/pis/*/authorisation/*/login", "/pis-cancellation/*/authorisation/*/login", "/ais/auth/**", "/ais/*/authorisation/*/login"};
    private static final String[] ACTUATOR_WHITELIST = new String[]{"/actuator/health"};
    private final TokenAuthenticationService tokenAuthenticationService;

    public void configure(WebSecurity web) {
        web.ignoring().antMatchers(new String[]{"/error"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(APP_INDEX_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(APP_SCA_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(SWAGGER_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(ACTUATOR_WHITELIST)).permitAll().and()).cors().and()).authorizeRequests().anyRequest()).authenticated();
        ((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.headers().frameOptions().disable();
        http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService), BasicAuthenticationFilter.class);
    }

    @Bean
    @RequestScope
    public Principal getPrincipal() {
        return WebSecurityConfig.auth().orElse(null);
    }

    @Bean
    @RequestScope
    public MiddlewareAuthentication getMiddlewareAuthentication() {
        return WebSecurityConfig.auth().orElse(null);
    }

    @Bean
    @RequestScope
    public AccessTokenTO getAccessToken() {
        return WebSecurityConfig.auth().map(arg_0 -> this.extractToken(arg_0)).orElse(null);
    }

    private static Optional<MiddlewareAuthentication> auth() {
        return SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext().getAuthentication() instanceof MiddlewareAuthentication) ? Optional.empty() : Optional.of((MiddlewareAuthentication)SecurityContextHolder.getContext().getAuthentication());
    }

    private AccessTokenTO extractToken(MiddlewareAuthentication authentication) {
        return authentication.getBearerToken().getAccessTokenObject();
    }

    public WebSecurityConfig(TokenAuthenticationService tokenAuthenticationService) {
        this.tokenAuthenticationService = tokenAuthenticationService;
    }
}

