/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.auth;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.rest.server.auth.MiddlewareAuthentication;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationService.class);
    private final UserMgmtRestClient ledgersUserMgmt;
    private final AuthRequestInterceptor authInterceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication getAuthentication(HttpServletRequest request) {
        String accessToken = this.readAccessTokenCookie(request);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            this.debug(String.format("Missing cookie with name %s.", "ACCESS_TOKEN"));
            return null;
        }
        BearerTokenTO bearerToken = null;
        try {
            this.authInterceptor.setAccessToken(accessToken);
            ResponseEntity responseEntity = this.ledgersUserMgmt.validate(accessToken);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                bearerToken = (BearerTokenTO)responseEntity.getBody();
            }
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
        if (bearerToken == null) {
            this.debug("Token is not valid.");
            return null;
        }
        AccessTokenTO token = bearerToken.getAccessTokenObject();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (token.getRole() != null) {
            authorities.add(new SimpleGrantedAuthority("ROLE_" + token.getRole().name()));
        }
        return new MiddlewareAuthentication((Object)token.getSub(), bearerToken, authorities);
    }

    private String readAccessTokenCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!"ACCESS_TOKEN".equalsIgnoreCase(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug(s);
        }
    }

    public TokenAuthenticationService(UserMgmtRestClient ledgersUserMgmt, AuthRequestInterceptor authInterceptor) {
        this.ledgersUserMgmt = ledgersUserMgmt;
        this.authInterceptor = authInterceptor;
    }
}

