/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.auth;

import de.adorsys.ledgers.oba.rest.server.auth.TokenAuthenticationService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class JWTAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private TokenAuthenticationService tokenAuthenticationService;

    public JWTAuthenticationFilter(TokenAuthenticationService tokenAuthenticationService) {
        this.tokenAuthenticationService = tokenAuthenticationService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication;
        if (log.isTraceEnabled()) {
            log.trace("doFilter start");
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Authentication is null. Try to get authentication from request...");
            }
            authentication = this.tokenAuthenticationService.getAuthentication((HttpServletRequest)request);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        filterChain.doFilter(request, response);
        if (log.isTraceEnabled()) {
            log.trace("doFilter end");
        }
    }
}

