package de.adorsys.ledgers.oba.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.ais.CmsAccountReference;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsBulkPayment;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-05-22T15:47:52+0200",
    comments = "version: 1.2.0.Final, compiler: javac, environment: Java 1.8.0_212 (Oracle Corporation)"
)
@Component
public class BulkPaymentMapperImpl implements BulkPaymentMapper {

    @Autowired
    private TimeMapper timeMapper;

    @Override
    public BulkPaymentTO toPayment(CmsBulkPayment payment) {
        if ( payment == null ) {
            return null;
        }

        BulkPaymentTO bulkPaymentTO = new BulkPaymentTO();

        bulkPaymentTO.setPaymentId( payment.getPaymentId() );
        bulkPaymentTO.setBatchBookingPreferred( payment.isBatchBookingPreferred() );
        bulkPaymentTO.setDebtorAccount( cmsAccountReferenceToAccountReferenceTO( payment.getDebtorAccount() ) );
        bulkPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        bulkPaymentTO.setPaymentStatus( transactionStatusToTransactionStatusTO( payment.getPaymentStatus() ) );
        bulkPaymentTO.setPayments( cmsSinglePaymentListToSinglePaymentTOList( payment.getPayments() ) );

        bulkPaymentTO.setPaymentProduct( de.adorsys.ledgers.oba.rest.server.mapper.ProductTOMapper.map(payment.getPaymentProduct()) );

        return bulkPaymentTO;
    }

    protected AccountReferenceTO cmsAccountReferenceToAccountReferenceTO(CmsAccountReference cmsAccountReference) {
        if ( cmsAccountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( cmsAccountReference.getIban() );
        accountReferenceTO.setBban( cmsAccountReference.getBban() );
        accountReferenceTO.setPan( cmsAccountReference.getPan() );
        accountReferenceTO.setMaskedPan( cmsAccountReference.getMaskedPan() );
        accountReferenceTO.setMsisdn( cmsAccountReference.getMsisdn() );
        accountReferenceTO.setCurrency( cmsAccountReference.getCurrency() );

        return accountReferenceTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        if ( transactionStatus == null ) {
            return null;
        }

        TransactionStatusTO transactionStatusTO;

        switch ( transactionStatus ) {
            case ACCC: transactionStatusTO = TransactionStatusTO.ACCC;
            break;
            case ACCP: transactionStatusTO = TransactionStatusTO.ACCP;
            break;
            case ACSC: transactionStatusTO = TransactionStatusTO.ACSC;
            break;
            case ACSP: transactionStatusTO = TransactionStatusTO.ACSP;
            break;
            case ACTC: transactionStatusTO = TransactionStatusTO.ACTC;
            break;
            case ACWC: transactionStatusTO = TransactionStatusTO.ACWC;
            break;
            case ACWP: transactionStatusTO = TransactionStatusTO.ACWP;
            break;
            case RCVD: transactionStatusTO = TransactionStatusTO.RCVD;
            break;
            case PDNG: transactionStatusTO = TransactionStatusTO.PDNG;
            break;
            case RJCT: transactionStatusTO = TransactionStatusTO.RJCT;
            break;
            case CANC: transactionStatusTO = TransactionStatusTO.CANC;
            break;
            case ACFC: transactionStatusTO = TransactionStatusTO.ACFC;
            break;
            case PATC: transactionStatusTO = TransactionStatusTO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatus );
        }

        return transactionStatusTO;
    }

    protected AmountTO cmsAmountToAmountTO(CmsAmount cmsAmount) {
        if ( cmsAmount == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( cmsAmount.getCurrency() );
        amountTO.setAmount( cmsAmount.getAmount() );

        return amountTO;
    }

    protected AddressTO cmsAddressToAddressTO(CmsAddress cmsAddress) {
        if ( cmsAddress == null ) {
            return null;
        }

        AddressTO addressTO = new AddressTO();

        addressTO.setStreet( cmsAddress.getStreet() );
        addressTO.setBuildingNumber( cmsAddress.getBuildingNumber() );
        addressTO.setCity( cmsAddress.getCity() );
        addressTO.setPostalCode( cmsAddress.getPostalCode() );
        addressTO.setCountry( cmsAddress.getCountry() );

        return addressTO;
    }

    protected SinglePaymentTO cmsSinglePaymentToSinglePaymentTO(CmsSinglePayment cmsSinglePayment) {
        if ( cmsSinglePayment == null ) {
            return null;
        }

        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();

        singlePaymentTO.setPaymentId( cmsSinglePayment.getPaymentId() );
        singlePaymentTO.setEndToEndIdentification( cmsSinglePayment.getEndToEndIdentification() );
        singlePaymentTO.setDebtorAccount( cmsAccountReferenceToAccountReferenceTO( cmsSinglePayment.getDebtorAccount() ) );
        singlePaymentTO.setInstructedAmount( cmsAmountToAmountTO( cmsSinglePayment.getInstructedAmount() ) );
        singlePaymentTO.setCreditorAccount( cmsAccountReferenceToAccountReferenceTO( cmsSinglePayment.getCreditorAccount() ) );
        singlePaymentTO.setCreditorAgent( cmsSinglePayment.getCreditorAgent() );
        singlePaymentTO.setCreditorName( cmsSinglePayment.getCreditorName() );
        singlePaymentTO.setCreditorAddress( cmsAddressToAddressTO( cmsSinglePayment.getCreditorAddress() ) );
        singlePaymentTO.setRemittanceInformationUnstructured( cmsSinglePayment.getRemittanceInformationUnstructured() );
        singlePaymentTO.setPaymentStatus( transactionStatusToTransactionStatusTO( cmsSinglePayment.getPaymentStatus() ) );
        if ( cmsSinglePayment.getPaymentProduct() != null ) {
            singlePaymentTO.setPaymentProduct( Enum.valueOf( PaymentProductTO.class, cmsSinglePayment.getPaymentProduct() ) );
        }
        singlePaymentTO.setRequestedExecutionDate( cmsSinglePayment.getRequestedExecutionDate() );
        singlePaymentTO.setRequestedExecutionTime( timeMapper.map( cmsSinglePayment.getRequestedExecutionTime() ) );

        return singlePaymentTO;
    }

    protected List<SinglePaymentTO> cmsSinglePaymentListToSinglePaymentTOList(List<CmsSinglePayment> list) {
        if ( list == null ) {
            return null;
        }

        List<SinglePaymentTO> list1 = new ArrayList<SinglePaymentTO>( list.size() );
        for ( CmsSinglePayment cmsSinglePayment : list ) {
            list1.add( cmsSinglePaymentToSinglePaymentTO( cmsSinglePayment ) );
        }

        return list1;
    }
}
