/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.oba.rest.server.mapper.ProductTOMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.SinglePaymentMapper;
import de.adorsys.ledgers.oba.rest.server.mapper.SinglePaymentMapperImpl;
import de.adorsys.ledgers.oba.rest.server.mapper.TimeMapper;
import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.ais.CmsAccountReference;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePaymentMapperImpl
implements SinglePaymentMapper {
    @Autowired
    private TimeMapper timeMapper;

    public SinglePaymentTO toPayment(CmsSinglePayment payment) {
        if (payment == null) {
            return null;
        }
        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();
        singlePaymentTO.setPaymentId(payment.getPaymentId());
        singlePaymentTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        singlePaymentTO.setDebtorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        singlePaymentTO.setInstructedAmount(this.cmsAmountToAmountTO(payment.getInstructedAmount()));
        singlePaymentTO.setCreditorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getCreditorAccount()));
        singlePaymentTO.setCreditorAgent(payment.getCreditorAgent());
        singlePaymentTO.setCreditorName(payment.getCreditorName());
        singlePaymentTO.setCreditorAddress(this.cmsAddressToAddressTO(payment.getCreditorAddress()));
        singlePaymentTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        singlePaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        singlePaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        singlePaymentTO.setRequestedExecutionTime(this.timeMapper.map(payment.getRequestedExecutionTime()));
        singlePaymentTO.setPaymentProduct(ProductTOMapper.map((String)payment.getPaymentProduct()));
        return singlePaymentTO;
    }

    protected AccountReferenceTO cmsAccountReferenceToAccountReferenceTO(CmsAccountReference cmsAccountReference) {
        if (cmsAccountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(cmsAccountReference.getIban());
        accountReferenceTO.setBban(cmsAccountReference.getBban());
        accountReferenceTO.setPan(cmsAccountReference.getPan());
        accountReferenceTO.setMaskedPan(cmsAccountReference.getMaskedPan());
        accountReferenceTO.setMsisdn(cmsAccountReference.getMsisdn());
        accountReferenceTO.setCurrency(cmsAccountReference.getCurrency());
        return accountReferenceTO;
    }

    protected AmountTO cmsAmountToAmountTO(CmsAmount cmsAmount) {
        if (cmsAmount == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(cmsAmount.getCurrency());
        amountTO.setAmount(cmsAmount.getAmount());
        return amountTO;
    }

    protected AddressTO cmsAddressToAddressTO(CmsAddress cmsAddress) {
        if (cmsAddress == null) {
            return null;
        }
        AddressTO addressTO = new AddressTO();
        addressTO.setStreet(cmsAddress.getStreet());
        addressTO.setBuildingNumber(cmsAddress.getBuildingNumber());
        addressTO.setCity(cmsAddress.getCity());
        addressTO.setPostalCode(cmsAddress.getPostalCode());
        addressTO.setCountry(cmsAddress.getCountry());
        return addressTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        TransactionStatusTO transactionStatusTO;
        if (transactionStatus == null) {
            return null;
        }
        switch (1.$SwitchMap$de$adorsys$psd2$xs2a$core$pis$TransactionStatus[transactionStatus.ordinal()]) {
            case 1: {
                transactionStatusTO = TransactionStatusTO.ACCC;
                break;
            }
            case 2: {
                transactionStatusTO = TransactionStatusTO.ACCP;
                break;
            }
            case 3: {
                transactionStatusTO = TransactionStatusTO.ACSC;
                break;
            }
            case 4: {
                transactionStatusTO = TransactionStatusTO.ACSP;
                break;
            }
            case 5: {
                transactionStatusTO = TransactionStatusTO.ACTC;
                break;
            }
            case 6: {
                transactionStatusTO = TransactionStatusTO.ACWC;
                break;
            }
            case 7: {
                transactionStatusTO = TransactionStatusTO.ACWP;
                break;
            }
            case 8: {
                transactionStatusTO = TransactionStatusTO.RCVD;
                break;
            }
            case 9: {
                transactionStatusTO = TransactionStatusTO.PDNG;
                break;
            }
            case 10: {
                transactionStatusTO = TransactionStatusTO.RJCT;
                break;
            }
            case 11: {
                transactionStatusTO = TransactionStatusTO.CANC;
                break;
            }
            case 12: {
                transactionStatusTO = TransactionStatusTO.ACFC;
                break;
            }
            case 13: {
                transactionStatusTO = TransactionStatusTO.PATC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + transactionStatus);
            }
        }
        return transactionStatusTO;
    }
}

