/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.consentref;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReference;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentReferencePolicy;
import de.adorsys.ledgers.oba.rest.api.consentref.ConsentType;
import de.adorsys.ledgers.oba.rest.api.consentref.InvalidConsentException;
import de.adorsys.ledgers.util.Ids;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DefaultConsentReferencePolicy
implements ConsentReferencePolicy {
    private static final String CONSENT_TYPE_JWT_CLAIM_NAME = "consent-type";
    private static final String REDIRECT_ID_JWT_CLAIM_NAME = "redirect-id";
    private static final String ENC_CONSENT_ID_JWT_CLAIM_NAME = "enc-consent-id";
    private static final String AUTH_ID_JWT_CLAIM_NAME = "auth-id";
    private static final Logger logger = LoggerFactory.getLogger(DefaultConsentReferencePolicy.class);
    @Value(value="${online-banking.sca.jwt.hs256.secret}")
    private String hmacSecret;

    public ConsentReference fromURL(String redirectId, ConsentType consentType, String encryptedConsentId) throws InvalidConsentException {
        ConsentReference cr = new ConsentReference();
        cr.setRedirectId(redirectId);
        cr.setConsentType(consentType);
        cr.setEncryptedConsentId(encryptedConsentId);
        String cookieString = this.toClaim(cr);
        cr.setCookieString(cookieString);
        return cr;
    }

    public ConsentReference fromRequest(String encryptedConsentId, String authorizationId, String cookieString, boolean strict) throws InvalidConsentException {
        return this.verifyParseJWT(encryptedConsentId, authorizationId, cookieString, strict);
    }

    private String toClaim(ConsentReference ref) {
        Date now = new Date();
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().jwtID(Ids.id()).claim(REDIRECT_ID_JWT_CLAIM_NAME, (Object)ref.getRedirectId()).claim(CONSENT_TYPE_JWT_CLAIM_NAME, (Object)ref.getConsentType().name()).claim(ENC_CONSENT_ID_JWT_CLAIM_NAME, (Object)ref.getEncryptedConsentId()).claim(AUTH_ID_JWT_CLAIM_NAME, (Object)ref.getAuthorizationId()).expirationTime(DateUtils.addSeconds((Date)now, (int)300)).issueTime(now).build();
        return this.signJWT(claimsSet);
    }

    private String signJWT(JWTClaimsSet claimsSet) {
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.HS256).keyID(Ids.id()).build();
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        try {
            signedJWT.sign((JWSSigner)new MACSigner(this.hmacSecret));
        }
        catch (JOSEException e) {
            throw new IllegalStateException("Error signing user token", e);
        }
        return signedJWT.serialize();
    }

    private ConsentReference verifyParseJWT(String encryptedConsentId, String authorizationId, String cookieString, boolean strict) throws InvalidConsentException {
        Date refTime = new Date();
        try {
            SignedJWT jwt = SignedJWT.parse((String)cookieString);
            JWTClaimsSet jwtClaimsSet = jwt.getJWTClaimsSet();
            Object authorizationIdClaim = jwtClaimsSet.getClaim(AUTH_ID_JWT_CLAIM_NAME);
            if (strict && authorizationIdClaim == null) {
                throw this.invalidConsent(String.format("Wrong jwt. CSRF allert. Missing claim %s for jwt with redirectId %s", AUTH_ID_JWT_CLAIM_NAME, jwtClaimsSet.getClaim(REDIRECT_ID_JWT_CLAIM_NAME)));
            }
            if (authorizationIdClaim != null && !StringUtils.equalsIgnoreCase((CharSequence)authorizationIdClaim.toString(), (CharSequence)authorizationId)) {
                throw this.invalidConsent(String.format("Wrong jwt. CSRF allert. Wrong %s for token with redirectId %s", AUTH_ID_JWT_CLAIM_NAME, jwtClaimsSet.getClaim(REDIRECT_ID_JWT_CLAIM_NAME)));
            }
            Object encryptedConsentIdClaim = jwtClaimsSet.getClaim(ENC_CONSENT_ID_JWT_CLAIM_NAME);
            if (encryptedConsentIdClaim == null || !StringUtils.equalsIgnoreCase((CharSequence)encryptedConsentIdClaim.toString(), (CharSequence)encryptedConsentId)) {
                throw this.invalidConsent(String.format("Wrong jwt. CSRF allert. Wrong %s for token with redirectId %s", ENC_CONSENT_ID_JWT_CLAIM_NAME, jwtClaimsSet.getClaim(REDIRECT_ID_JWT_CLAIM_NAME)));
            }
            JWSHeader header = jwt.getHeader();
            if (!JWSAlgorithm.HS256.equals((Object)header.getAlgorithm())) {
                throw this.invalidConsent(String.format("Wrong jws algo for token with subject : %s", jwtClaimsSet.getSubject()));
            }
            if (jwtClaimsSet.getExpirationTime() == null || jwtClaimsSet.getExpirationTime().before(refTime)) {
                throw this.invalidConsent(String.format("Token with subject %s is expired at %s and reference time is %s : ", jwtClaimsSet.getSubject(), jwtClaimsSet.getExpirationTime(), refTime));
            }
            boolean verified = jwt.verify((JWSVerifier)new MACVerifier(this.hmacSecret));
            if (!verified) {
                throw this.invalidConsent(String.format("Could not verify signature of token with subject %s: ", jwtClaimsSet.getSubject()));
            }
            return this.consentReference(encryptedConsentId, authorizationId, jwtClaimsSet);
        }
        catch (JOSEException | ParseException e) {
            throw this.invalidConsent(e.getMessage());
        }
    }

    private ConsentReference consentReference(String encryptedConsentId, String authorizationId, JWTClaimsSet jwtClaimsSet) {
        ConsentReference cr = new ConsentReference();
        cr.setConsentType(ConsentType.valueOf((String)jwtClaimsSet.getClaim(CONSENT_TYPE_JWT_CLAIM_NAME).toString()));
        cr.setRedirectId(jwtClaimsSet.getClaim(REDIRECT_ID_JWT_CLAIM_NAME).toString());
        cr.setEncryptedConsentId(encryptedConsentId);
        cr.setAuthorizationId(authorizationId);
        cr.setCookieString(this.toClaim(cr));
        return cr;
    }

    private InvalidConsentException invalidConsent(String message) throws InvalidConsentException {
        logger.warn(message);
        return new InvalidConsentException(message);
    }
}

