/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.mappers.PaymentMapperTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.OauthRestClient;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.middleware.client.rest.RedirectScaRestClient;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthorizationException;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.AuthorizationService;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import de.adorsys.ledgers.oba.service.impl.service.CmsAspspConsentDataService;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.pis.CmsCommonPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.psu.api.CmsPsuAuthorisation;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import org.adorsys.ledgers.consent.xs2a.rest.client.AspspConsentDataClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonPaymentServiceImpl
implements CommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(CommonPaymentServiceImpl.class);
    private final ConsentReferencePolicy referencePolicy;
    private final AuthRequestInterceptor authInterceptor;
    private final CmsPsuPisService cmsPsuPisService;
    private final PaymentRestClient paymentRestClient;
    private final AspspConsentDataClient aspspConsentDataClient;
    private final CmsAspspConsentDataService dataService;
    private final PaymentMapperTO paymentMapper;
    private final OauthRestClient oauthRestClient;
    private final AuthorizationService authService;
    private final RedirectScaRestClient redirectScaClient;

    public PaymentWorkflow selectScaForPayment(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndAccessTokenCookieString, String psuId, BearerTokenTO tokenTO) {
        PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndAccessTokenCookieString, psuId, tokenTO);
        this.selectMethodAndUpdateWorkflow(scaMethodId, encryptedPaymentId, workflow);
        this.doUpdateAuthData(psuId, workflow);
        return workflow;
    }

    public PaymentWorkflow identifyPayment(String encryptedPaymentId, String authorizationId, boolean strict, String consentCookieString, String psuId, BearerTokenTO bearerToken) {
        ConsentReference consentReference = this.referencePolicy.fromRequest(encryptedPaymentId, authorizationId, consentCookieString, strict);
        CmsPaymentResponse cmsPaymentResponse = this.loadPaymentByRedirectId(consentReference);
        PaymentWorkflow workflow = new PaymentWorkflow(cmsPaymentResponse, consentReference);
        PaymentTO payment = this.getPaymentTO(workflow);
        workflow.setAuthResponse(new PaymentAuthorizeResponse(payment));
        workflow.getAuthResponse().setAuthorisationId(cmsPaymentResponse.getAuthorisationId());
        workflow.getAuthResponse().setEncryptedConsentId(encryptedPaymentId);
        workflow.setPaymentStatus(Optional.ofNullable(payment.getTransactionStatus()).map(Enum::name).orElse("RCVD"));
        if (bearerToken != null) {
            GlobalScaResponseTO response = new GlobalScaResponseTO();
            response.setBearerToken(bearerToken);
            workflow.setScaResponse(response);
        }
        return workflow;
    }

    public void updateAspspConsentData(PaymentWorkflow paymentWorkflow) {
        CmsAspspConsentDataBase64 consentData;
        try {
            consentData = new CmsAspspConsentDataBase64(paymentWorkflow.paymentId(), this.dataService.toBase64String(paymentWorkflow.getScaResponse()));
        }
        catch (IOException e) {
            throw AuthorizationException.builder().errorCode(AuthErrorCode.CONSENT_DATA_UPDATE_FAILED).devMessage("Consent data update failed").build();
        }
        this.aspspConsentDataClient.updateAspspConsentData(paymentWorkflow.getConsentReference().getEncryptedConsentId(), consentData);
    }

    public String resolveRedirectUrl(String encryptedPaymentId, String authorisationId, String consentAndAccessTokenCookieString, boolean isOauth2Integrated, String psuId, BearerTokenTO tokenTO, String authConfirmationCode) {
        PaymentWorkflow workflow = this.identifyPayment(encryptedPaymentId, authorisationId, true, consentAndAccessTokenCookieString, psuId, tokenTO);
        CmsPaymentResponse consentResponse = workflow.getPaymentResponse();
        this.authInterceptor.setAccessToken(workflow.getScaResponse().getBearerToken().getAccess_token());
        String tppOkRedirectUri = isOauth2Integrated ? Objects.requireNonNull((OauthCodeResponseTO)this.oauthRestClient.oauthCode(consentResponse.getTppOkRedirectUri()).getBody()).getRedirectUri() : this.authService.resolveAuthConfirmationCodeRedirectUri(consentResponse.getTppOkRedirectUri(), authConfirmationCode);
        String tppNokRedirectUri = consentResponse.getTppNokRedirectUri();
        ScaStatusTO scaStatus = this.loadAuthorization(workflow.authId());
        return EnumSet.of(ScaStatusTO.FINALISED, ScaStatusTO.UNCONFIRMED, ScaStatusTO.EXEMPTED).contains(scaStatus) ? tppOkRedirectUri : tppNokRedirectUri;
    }

    public PaymentWorkflow initiatePaymentOpr(PaymentWorkflow paymentWorkflow, String psuId, OpTypeTO opType) {
        this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
        SCAPaymentResponseTO paymentResponseTO = opType == OpTypeTO.PAYMENT ? (SCAPaymentResponseTO)this.paymentRestClient.initiatePayment(paymentWorkflow.paymentType(), paymentWorkflow.getAuthResponse().getPayment()).getBody() : (SCAPaymentResponseTO)this.paymentRestClient.initiatePmtCancellation(paymentWorkflow.paymentId()).getBody();
        GlobalScaResponseTO response = this.dataService.mapToGlobalResponse(Objects.requireNonNull(paymentResponseTO), opType);
        paymentWorkflow.processSCAResponse(response);
        paymentWorkflow.setPaymentStatus(paymentResponseTO.getTransactionStatus().name());
        this.doUpdateAuthData(psuId, paymentWorkflow);
        return paymentWorkflow;
    }

    public PaymentWorkflow authorizePaymentOpr(PaymentWorkflow paymentWorkflow, String psuId, String authCode, OpTypeTO opType) {
        this.authInterceptor.setAccessToken(paymentWorkflow.bearerToken().getAccess_token());
        GlobalScaResponseTO response = (GlobalScaResponseTO)this.redirectScaClient.validateScaCode(paymentWorkflow.authId(), authCode).getBody();
        this.authInterceptor.setAccessToken(Objects.requireNonNull(response).getBearerToken().getAccess_token());
        SCAPaymentResponseTO scaPaymentResponse = opType == OpTypeTO.PAYMENT ? (SCAPaymentResponseTO)this.paymentRestClient.executePayment(paymentWorkflow.paymentId()).getBody() : (SCAPaymentResponseTO)this.paymentRestClient.executeCancelPayment(paymentWorkflow.paymentId()).getBody();
        paymentWorkflow.processSCAResponse(response);
        paymentWorkflow.setPaymentStatus(opType == OpTypeTO.PAYMENT ? Objects.requireNonNull(scaPaymentResponse).getTransactionStatus().name() : TransactionStatusTO.CANC.toString());
        this.doUpdateAuthData(psuId, paymentWorkflow);
        return paymentWorkflow;
    }

    private void doUpdateAuthData(String psuId, PaymentWorkflow workflow) {
        this.updateAuthorisationStatus(workflow, psuId);
        this.updatePaymentStatus(workflow);
        this.updateAspspConsentData(workflow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectMethodAndUpdateWorkflow(String scaMethodId, String externalId, PaymentWorkflow workflow) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            StartScaOprTO opr = new StartScaOprTO(workflow.paymentId(), externalId, workflow.authId(), OpTypeTO.PAYMENT);
            GlobalScaResponseTO response = (GlobalScaResponseTO)this.redirectScaClient.startSca(opr).getBody();
            response = (GlobalScaResponseTO)this.redirectScaClient.selectMethod(Objects.requireNonNull(response).getAuthorisationId(), scaMethodId).getBody();
            workflow.processSCAResponse(Objects.requireNonNull(response));
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    private void updateAuthorisationStatus(PaymentWorkflow workflow, String psuId) {
        String paymentId = workflow.getPaymentResponse().getPayment().getPaymentId();
        String authorisationId = workflow.getPaymentResponse().getAuthorisationId();
        String status = workflow.getAuthResponse().getScaStatus().name();
        try {
            this.cmsPsuPisService.updateAuthorisationStatus(new PsuIdData(psuId, null, null, null, null), paymentId, authorisationId, ScaStatus.valueOf((String)status), "UNDEFINED", new AuthenticationDataHolder(null, workflow.getScaResponse().getAuthConfirmationCode()));
        }
        catch (AuthorisationIsExpiredException e) {
            log.error("Authorization for your payment has expired!");
            throw ObaException.builder().obaErrorCode(ObaErrorCode.AUTH_EXPIRED).devMessage(e.getMessage()).build();
        }
    }

    private CmsPaymentResponse loadPaymentByRedirectId(ConsentReference consentReference) {
        String redirectId = consentReference.getRedirectId();
        try {
            return (CmsPaymentResponse)this.cmsPsuPisService.checkRedirectAndGetPayment(redirectId, "UNDEFINED").orElseThrow(() -> new RedirectUrlIsExpiredException(null));
        }
        catch (RedirectUrlIsExpiredException e) {
            throw ObaException.builder().obaErrorCode(ObaErrorCode.NOT_FOUND).devMessage(String.format("Could not retrieve payment %s from CMS", redirectId)).build();
        }
    }

    private ScaStatusTO loadAuthorization(String authorizationId) {
        return this.cmsPsuPisService.getAuthorisationByAuthorisationId(authorizationId, "UNDEFINED").map(CmsPsuAuthorisation::getScaStatus).map(Enum::name).map(ScaStatusTO::valueOf).orElseThrow(() -> ObaException.builder().obaErrorCode(ObaErrorCode.NOT_FOUND).devMessage("Authorization for payment not found!").build());
    }

    private void updatePaymentStatus(PaymentWorkflow paymentWorkflow) {
        this.cmsPsuPisService.updatePaymentStatus(paymentWorkflow.getPaymentResponse().getPayment().getPaymentId(), TransactionStatus.valueOf((String)paymentWorkflow.getPaymentStatus()), "UNDEFINED");
        paymentWorkflow.getAuthResponse().getPayment().setTransactionStatus(TransactionStatusTO.valueOf((String)paymentWorkflow.getPaymentStatus()));
    }

    private PaymentTO getPaymentTO(PaymentWorkflow workflow) {
        CmsCommonPayment payment = (CmsCommonPayment)workflow.getPaymentResponse().getPayment();
        String paymentString = new String(payment.getPaymentData(), StandardCharsets.UTF_8);
        PaymentTO abstractPayment = this.paymentMapper.toAbstractPayment(paymentString, workflow.paymentType().name(), payment.getPaymentProduct());
        abstractPayment.setPaymentId(workflow.paymentId());
        abstractPayment.setTransactionStatus(TransactionStatusTO.valueOf((String)payment.getTransactionStatus().name()));
        return abstractPayment;
    }

    public CommonPaymentServiceImpl(ConsentReferencePolicy referencePolicy, AuthRequestInterceptor authInterceptor, CmsPsuPisService cmsPsuPisService, PaymentRestClient paymentRestClient, AspspConsentDataClient aspspConsentDataClient, CmsAspspConsentDataService dataService, PaymentMapperTO paymentMapper, OauthRestClient oauthRestClient, AuthorizationService authService, RedirectScaRestClient redirectScaClient) {
        this.referencePolicy = referencePolicy;
        this.authInterceptor = authInterceptor;
        this.cmsPsuPisService = cmsPsuPisService;
        this.paymentRestClient = paymentRestClient;
        this.aspspConsentDataClient = aspspConsentDataClient;
        this.dataService = dataService;
        this.paymentMapper = paymentMapper;
        this.oauthRestClient = oauthRestClient;
        this.authService = authService;
        this.redirectScaClient = redirectScaClient;
    }
}

