/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import java.io.IOException;
import java.util.Base64;
import org.springframework.stereotype.Service;

@Service
public class CmsAspspConsentDataService {
    private final ObjectMapper mapper;

    public GlobalScaResponseTO fromBytes(byte[] tokenBytes) throws IOException {
        String type = this.readType(tokenBytes);
        if (SCAConsentResponseTO.class.getSimpleName().equals(type)) {
            return this.mapToGlobalResponse((SCAConsentResponseTO)this.mapper.readValue(tokenBytes, SCAConsentResponseTO.class), OpTypeTO.CONSENT);
        }
        if (SCALoginResponseTO.class.getSimpleName().equals(type)) {
            return this.mapToGlobalResponse((SCALoginResponseTO)this.mapper.readValue(tokenBytes, SCALoginResponseTO.class), OpTypeTO.LOGIN);
        }
        if (SCAPaymentResponseTO.class.getSimpleName().equals(type)) {
            return this.mapToGlobalResponse((SCAPaymentResponseTO)this.mapper.readValue(tokenBytes, SCAPaymentResponseTO.class), OpTypeTO.PAYMENT);
        }
        return (GlobalScaResponseTO)this.mapper.readValue(tokenBytes, GlobalScaResponseTO.class);
    }

    public byte[] toBytes(GlobalScaResponseTO response) throws IOException {
        return this.mapper.writeValueAsBytes((Object)response);
    }

    private String readType(byte[] tokenBytes) throws IOException {
        JsonNode jsonNode = this.mapper.readTree(tokenBytes);
        JsonNode objectType = jsonNode.get("objectType");
        if (objectType == null) {
            return null;
        }
        return objectType.toString();
    }

    public String toBase64String(GlobalScaResponseTO response) throws IOException {
        return Base64.getEncoder().encodeToString(this.toBytes(response));
    }

    public <T extends SCAResponseTO> GlobalScaResponseTO mapToGlobalResponse(T source, OpTypeTO type) {
        GlobalScaResponseTO target = new GlobalScaResponseTO();
        target.setOpType(type);
        target.setAuthorisationId(source.getAuthorisationId());
        target.setScaStatus(source.getScaStatus());
        target.setScaMethods(source.getScaMethods());
        target.setChallengeData(source.getChallengeData());
        target.setPsuMessage(source.getPsuMessage());
        target.setStatusDate(source.getStatusDate());
        target.setExpiresInSeconds(source.getExpiresInSeconds());
        target.setMultilevelScaRequired(source.isMultilevelScaRequired());
        target.setAuthConfirmationCode(source.getAuthConfirmationCode());
        target.setTan(null);
        target.setBearerToken(source.getBearerToken());
        if (OpTypeTO.PAYMENT == type) {
            SCAPaymentResponseTO t = (SCAPaymentResponseTO)source;
            target.setOperationObjectId(t.getPaymentId());
            target.setPartiallyAuthorised(t.getTransactionStatus() == TransactionStatusTO.PATC);
        } else if (OpTypeTO.CONSENT == type) {
            SCAConsentResponseTO t = (SCAConsentResponseTO)source;
            target.setOperationObjectId(t.getConsentId());
            target.setPartiallyAuthorised(t.isPartiallyAuthorised());
        } else {
            target.setOperationObjectId(source.getAuthorisationId());
            target.setPartiallyAuthorised(source.isMultilevelScaRequired());
        }
        return target;
    }

    public CmsAspspConsentDataService(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

