/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.service.api.domain.UserAuthentication;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.TokenAuthenticationService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthenticationServiceImpl
implements TokenAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationServiceImpl.class);
    private final UserMgmtRestClient ledgersUserMgmt;
    private final AuthRequestInterceptor authInterceptor;
    private final KeycloakTokenService tokenService;

    public UserAuthentication getAuthentication(String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        BearerTokenTO bearerToken = this.tokenService.validate(accessToken);
        if (bearerToken == null) {
            this.debug();
            return null;
        }
        return new UserAuthentication(bearerToken);
    }

    private void debug() {
        if (log.isDebugEnabled()) {
            log.debug("Token is not valid.");
        }
    }

    public GlobalScaResponseTO login(String login, String pin, String authorizationId) {
        if (StringUtils.isBlank((CharSequence)authorizationId) || StringUtils.isBlank((CharSequence)login) || StringUtils.isBlank((CharSequence)pin)) {
            throw ObaException.builder().devMessage("Authorization Id is missing!").obaErrorCode(ObaErrorCode.LOGIN_FAILED).build();
        }
        GlobalScaResponseTO response = this.login(login, pin);
        response.setAuthorisationId(authorizationId);
        return response;
    }

    public GlobalScaResponseTO login(String login, String pin) {
        if (StringUtils.isBlank((CharSequence)login) || StringUtils.isBlank((CharSequence)pin)) {
            throw ObaException.builder().devMessage("Authorization Id is missing!").obaErrorCode(ObaErrorCode.LOGIN_FAILED).build();
        }
        try {
            BearerTokenTO token = this.tokenService.login(login, pin);
            return this.getScaResponseTO(token.getAccess_token());
        }
        catch (Exception e) {
            throw this.throwException(e);
        }
    }

    private GlobalScaResponseTO getScaResponseTO(String tokenString) {
        BearerTokenTO token = this.tokenService.validate(tokenString);
        this.authInterceptor.setAccessToken(token.getAccess_token());
        UserTO user = (UserTO)this.ledgersUserMgmt.getUser().getBody();
        GlobalScaResponseTO response = new GlobalScaResponseTO();
        response.setBearerToken(token);
        response.setScaMethods(Objects.requireNonNull(user).getScaUserData());
        response.setScaStatus(ScaStatusTO.PSUIDENTIFIED);
        this.authInterceptor.setAccessToken(null);
        return response;
    }

    private ObaException throwException(Exception e) {
        log.error(e.getMessage());
        this.authInterceptor.setAccessToken(null);
        return ObaException.builder().devMessage(e.getMessage()).obaErrorCode(ObaErrorCode.LOGIN_FAILED).build();
    }

    public TokenAuthenticationServiceImpl(UserMgmtRestClient ledgersUserMgmt, AuthRequestInterceptor authInterceptor, KeycloakTokenService tokenService) {
        this.ledgersUserMgmt = ledgersUserMgmt;
        this.authInterceptor = authInterceptor;
        this.tokenService = tokenService;
    }
}

