/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.OperationInitiationRestClient;
import de.adorsys.ledgers.middleware.client.rest.RedirectScaRestClient;
import de.adorsys.ledgers.oba.service.api.domain.ConsentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.ConsentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.CmsAspspConsentDataService;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import de.adorsys.ledgers.oba.service.api.service.RedirectConsentService;
import de.adorsys.ledgers.oba.service.impl.mapper.ObaAisConsentMapper;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentAccessRequest;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import feign.FeignException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuAisClient;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuPiisV2Client;
import org.adorsys.ledgers.consent.xs2a.rest.client.AspspConsentDataClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RedirectConsentServiceImpl
implements RedirectConsentService {
    private static final Logger log = LoggerFactory.getLogger(RedirectConsentServiceImpl.class);
    private final CmsPsuAisClient cmsPsuAisClient;
    private final CmsPsuPiisV2Client cmsPsuPiisV2Client;
    private final OperationInitiationRestClient operationInitiationRestClient;
    private final AuthRequestInterceptor authInterceptor;
    private final ObaAisConsentMapper consentMapper;
    private final ConsentReferencePolicy referencePolicy;
    private final CmsAspspConsentDataService dataService;
    private final AspspConsentDataClient aspspConsentDataClient;
    private final RedirectScaRestClient redirectScaClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectScaMethod(String scaMethodId, String encryptedConsentId, ConsentWorkflow workflow) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            StartScaOprTO opr = new StartScaOprTO(workflow.consentId(), encryptedConsentId, workflow.authId(), OpTypeTO.CONSENT);
            GlobalScaResponseTO response = (GlobalScaResponseTO)this.redirectScaClient.startSca(opr).getBody();
            response = (GlobalScaResponseTO)this.redirectScaClient.selectMethod(Objects.requireNonNull(response).getAuthorisationId(), scaMethodId).getBody();
            workflow.storeSCAResponse(response);
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public ConsentWorkflow authorizeConsent(ConsentWorkflow workflow, String authCode) {
        this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
        GlobalScaResponseTO response = (GlobalScaResponseTO)this.redirectScaClient.validateScaCode(workflow.authId(), authCode).getBody();
        workflow.storeSCAResponse(response);
        workflow.setConsentStatus(Objects.requireNonNull(response).isPartiallyAuthorised() ? ConsentStatus.PARTIALLY_AUTHORISED.name() : ConsentStatus.VALID.name());
        return workflow;
    }

    public void updateAccessByConsentType(ConsentWorkflow workflow, List<AccountDetailsTO> listOfAccounts) {
        AisConsentRequestType consentType = workflow.getConsentResponse().getAccountConsent().getAisConsentRequestType();
        if (!EnumSet.of(AisConsentRequestType.BANK_OFFERED, AisConsentRequestType.DEDICATED_ACCOUNTS).contains(consentType)) {
            AisAccountAccessInfoTO authAccountAccess = workflow.getAuthResponse().getConsent().getAccess();
            List<String> ibans = this.extractUserIbans(listOfAccounts);
            authAccountAccess.setAccounts(ibans);
            if (AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS == consentType && this.requestedConsentWithBalance(workflow)) {
                authAccountAccess.setBalances(ibans);
            }
            if (AisConsentRequestType.GLOBAL == consentType) {
                authAccountAccess.setBalances(ibans);
                authAccountAccess.setTransactions(ibans);
            }
        }
        if (AisConsentRequestType.DEDICATED_ACCOUNTS == consentType) {
            HashSet<String> ibans = new HashSet<String>(this.extractUserIbans(listOfAccounts));
            Set<String> ibansFromAccess = this.extractIbansFromAccess(workflow.getConsentResponse().getAccountConsent().getAccess());
            this.checkAccess(ibansFromAccess, ibans);
        }
    }

    private void checkAccess(Set<String> ibansFromAccess, Set<String> ibans) {
        if (!ibans.containsAll(ibansFromAccess)) {
            throw ObaException.builder().obaErrorCode(ObaErrorCode.LOGIN_FAILED).devMessage("Operation you're logging in is not meant for current user").build();
        }
    }

    private Set<String> extractIbansFromAccess(AisAccountAccess access) {
        return Stream.of(access.getAccounts(), access.getBalances(), access.getTransactions()).flatMap(a -> a.stream().map(AccountReference::getIban)).collect(Collectors.toSet());
    }

    private List<String> extractUserIbans(List<AccountDetailsTO> accounts) {
        return accounts.stream().map(AccountDetailsTO::getIban).collect(Collectors.toList());
    }

    public void updateScaStatusAndConsentData(String psuId, ConsentWorkflow workflow) {
        this.updateCmsAuthorizationScaStatus(workflow, psuId);
        this.updateAspspConsentData(workflow);
    }

    private void updateCmsAuthorizationScaStatus(ConsentWorkflow workflow, String psuId) {
        block2: {
            String status = workflow.getAuthResponse().getScaStatus().name();
            try {
                this.cmsPsuAisClient.updateAuthorisationStatus(workflow.consentId(), status, workflow.authId(), psuId, null, null, null, "UNDEFINED", new AuthenticationDataHolder(null, workflow.getScaResponse().getAuthConfirmationCode()));
            }
            catch (FeignException e) {
                if (e.status() != 400 && e.status() != 404) break block2;
                this.cmsPsuPiisV2Client.updateAuthorisationStatus(workflow.consentId(), status, workflow.authId(), psuId, null, null, null, "UNDEFINED", new AuthenticationDataHolder(null, workflow.getScaResponse().getAuthConfirmationCode()));
            }
        }
    }

    private void updateAspspConsentData(ConsentWorkflow workflow) {
        CmsAspspConsentDataBase64 consentData = new CmsAspspConsentDataBase64(workflow.consentId(), this.dataService.toBase64String((Object)workflow.getScaResponse()));
        this.aspspConsentDataClient.updateAspspConsentData(workflow.getConsentReference().getEncryptedConsentId(), consentData);
    }

    public void startConsent(ConsentWorkflow workflow, AisConsentTO aisConsent, List<AccountDetailsTO> listOfAccounts) {
        AisAccountAccess accountAccess = this.consentMapper.accountAccess(aisConsent.getAccess(), listOfAccounts);
        CmsAisConsentAccessRequest accountAccessRequest = new CmsAisConsentAccessRequest(accountAccess, aisConsent.getValidUntil(), aisConsent.getFrequencyPerDay(), Boolean.valueOf(false), Boolean.valueOf(aisConsent.isRecurringIndicator()));
        try {
            this.cmsPsuAisClient.putAccountAccessInConsent(workflow.consentId(), accountAccessRequest, "UNDEFINED");
        }
        catch (FeignException e) {
            log.error("Consent not found expecting it is a PIIS consent");
        }
        AisConsentTO consent = this.consentMapper.toTo(workflow.getConsentResponse().getAccountConsent());
        consent.setAccess(aisConsent.getAccess());
        workflow.getAuthResponse().setConsent(consent);
        this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
        GlobalScaResponseTO globalScaResponseTO = (GlobalScaResponseTO)this.operationInitiationRestClient.initiateAisConsent(consent).getBody();
        workflow.storeSCAResponse(globalScaResponseTO);
    }

    public ConsentWorkflow identifyConsent(String encryptedConsentId, String authorizationId, BearerTokenTO bearerToken) {
        ConsentReference consentReference = this.referencePolicy.fromRequest(encryptedConsentId, authorizationId);
        CmsAisConsentResponse cmsConsentResponse = this.loadConsentByRedirectId(consentReference);
        ConsentWorkflow workflow = new ConsentWorkflow(cmsConsentResponse, consentReference);
        AisConsentTO aisConsentTO = this.consentMapper.toTo(Objects.requireNonNull(cmsConsentResponse).getAccountConsent());
        workflow.setAuthResponse(new ConsentAuthorizeResponse(aisConsentTO));
        workflow.getAuthResponse().setAuthorisationId(cmsConsentResponse.getAuthorisationId());
        workflow.getAuthResponse().setEncryptedConsentId(encryptedConsentId);
        if (bearerToken != null) {
            SCAConsentResponseTO scaConsentResponseTO = new SCAConsentResponseTO();
            scaConsentResponseTO.setBearerToken(bearerToken);
            workflow.setScaResponse(this.dataService.mapToGlobalResponse((SCAResponseTO)scaConsentResponseTO, OpTypeTO.CONSENT));
        }
        return workflow;
    }

    private CmsAisConsentResponse loadConsentByRedirectId(ConsentReference consentReference) {
        String redirectId = consentReference.getRedirectId();
        ResponseEntity responseEntity = this.cmsPsuAisClient.getConsentIdByRedirectId(redirectId, "UNDEFINED");
        return (CmsAisConsentResponse)responseEntity.getBody();
    }

    private boolean requestedConsentWithBalance(ConsentWorkflow workflow) {
        return StringUtils.isNotBlank((CharSequence)workflow.getConsentResponse().getAccountConsent().getAccess().getAvailableAccountsWithBalance());
    }

    public RedirectConsentServiceImpl(CmsPsuAisClient cmsPsuAisClient, CmsPsuPiisV2Client cmsPsuPiisV2Client, OperationInitiationRestClient operationInitiationRestClient, AuthRequestInterceptor authInterceptor, ObaAisConsentMapper consentMapper, ConsentReferencePolicy referencePolicy, CmsAspspConsentDataService dataService, AspspConsentDataClient aspspConsentDataClient, RedirectScaRestClient redirectScaClient) {
        this.cmsPsuAisClient = cmsPsuAisClient;
        this.cmsPsuPiisV2Client = cmsPsuPiisV2Client;
        this.operationInitiationRestClient = operationInitiationRestClient;
        this.authInterceptor = authInterceptor;
        this.consentMapper = consentMapper;
        this.referencePolicy = referencePolicy;
        this.dataService = dataService;
        this.aspspConsentDataClient = aspspConsentDataClient;
        this.redirectScaClient = redirectScaClient;
    }
}

