/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.ConsentType;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultConsentReferencePolicy
implements ConsentReferencePolicy {
    private static final Logger log = LoggerFactory.getLogger(DefaultConsentReferencePolicy.class);

    public ConsentReference fromURL(String redirectId, ConsentType consentType, String encryptedConsentId) {
        ConsentReference cr = new ConsentReference();
        cr.setRedirectId(redirectId);
        cr.setConsentType(consentType);
        cr.setEncryptedConsentId(encryptedConsentId);
        return cr;
    }

    public ConsentReference fromRequest(String encryptedConsentId, String authorizationId) {
        return this.consentReference(encryptedConsentId, authorizationId, ConsentType.AIS, authorizationId);
    }

    private ConsentReference consentReference(String encryptedConsentId, String authorizationId, ConsentType type, String redirectId) {
        ConsentReference cr = new ConsentReference();
        cr.setConsentType(type);
        cr.setRedirectId(redirectId);
        cr.setEncryptedConsentId(encryptedConsentId);
        cr.setAuthorizationId(authorizationId);
        return cr;
    }
}

