/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.OperationInitiationRestClient;
import de.adorsys.ledgers.middleware.client.rest.RedirectScaRestClient;
import de.adorsys.ledgers.oba.service.api.domain.DecoupledConfRequest;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.CmsAspspConsentDataService;
import de.adorsys.ledgers.oba.service.api.service.DecoupledService;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.util.EnumSet;
import java.util.Optional;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuAisClient;
import org.adorsys.ledgers.consent.xs2a.rest.client.AspspConsentDataClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DecoupledServiceImpl
implements DecoupledService {
    private static final Logger log = LoggerFactory.getLogger(DecoupledServiceImpl.class);
    private final KeycloakTokenService tokenService;
    private final AuthRequestInterceptor authInterceptor;
    private final OperationInitiationRestClient operationInitiationRestClient;
    private final RedirectScaRestClient redirectScaClient;
    private final CmsPsuPisService cmsPsuPisService;
    private final CmsPsuAisClient cmsPsuAisClient;
    private final CmsAspspConsentDataService dataService;
    private final AspspConsentDataClient aspspConsentDataClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeDecoupledOpr(DecoupledConfRequest request, String token) {
        try {
            BearerTokenTO scaToken = this.tokenService.exchangeToken(token, Integer.valueOf(request.getAuthorizationTTL()), "sca");
            this.authInterceptor.setAccessToken(scaToken.getAccess_token());
            GlobalScaResponseTO response = (GlobalScaResponseTO)this.redirectScaClient.validateScaCode(request.getAuthorizationId(), request.getAuthCode()).getBody();
            Optional.ofNullable(response).map(GlobalScaResponseTO::getBearerToken).map(BearerTokenTO::getAccess_token).ifPresent(arg_0 -> ((AuthRequestInterceptor)this.authInterceptor).setAccessToken(arg_0));
            if (EnumSet.of(OpTypeTO.PAYMENT, OpTypeTO.CANCEL_PAYMENT).contains(request.getOpType())) {
                String transactionStatus = this.executePaymentOperation(request, response);
                this.updateCmsForPayment(request.getAddressedUser(), response, transactionStatus);
            } else {
                this.updateCmForConsent(request.getAddressedUser(), response);
            }
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
        return true;
    }

    private String executePaymentOperation(DecoupledConfRequest request, GlobalScaResponseTO response) {
        GlobalScaResponseTO globalScaResponseTO = (GlobalScaResponseTO)this.operationInitiationRestClient.execution(request.getOpType(), request.getObjId()).getBody();
        if (!request.isConfirmed()) {
            response.setScaStatus(ScaStatusTO.FAILED);
            response.setBearerToken(null);
        }
        return Optional.ofNullable(globalScaResponseTO).map(GlobalScaResponseTO::getTransactionStatus).map(Enum::name).orElse(null);
    }

    private void updateCmForConsent(String psuId, GlobalScaResponseTO scaResponse) {
        this.updateCmsScaConsentStatus(psuId, scaResponse);
        this.updateConsentStatus(scaResponse);
        this.updateAspspConsentData(scaResponse);
    }

    private void updateCmsScaConsentStatus(String psuId, GlobalScaResponseTO scaResponse) {
        this.cmsPsuAisClient.updateAuthorisationStatus(scaResponse.getOperationObjectId(), scaResponse.getScaStatus().name(), scaResponse.getAuthorisationId(), psuId, null, null, null, "UNDEFINED", new AuthenticationDataHolder(null, scaResponse.getAuthConfirmationCode()));
    }

    private void updateCmsForPayment(String psuId, GlobalScaResponseTO scaResponse, String transactionStatus) {
        this.updateCmsScaPaymentAuthStatus(scaResponse, psuId);
        Optional.ofNullable(transactionStatus).ifPresent(s -> this.updatePaymentStatus(scaResponse.getOperationObjectId(), (String)s));
        this.updateAspspConsentData(scaResponse);
    }

    private void updateCmsScaPaymentAuthStatus(GlobalScaResponseTO scaResponse, String psuId) {
        try {
            this.cmsPsuPisService.updateAuthorisationStatus(new PsuIdData(psuId, null, null, null, null), scaResponse.getOperationObjectId(), scaResponse.getAuthorisationId(), ScaStatus.valueOf((String)scaResponse.getScaStatus().name()), "UNDEFINED", new AuthenticationDataHolder(null, scaResponse.getAuthConfirmationCode()));
        }
        catch (AuthorisationIsExpiredException e) {
            log.error("Authorization for your payment has expired!");
            throw ObaException.builder().obaErrorCode(ObaErrorCode.AUTH_EXPIRED).devMessage(e.getMessage()).build();
        }
    }

    private void updatePaymentStatus(String paymentId, String transactionStatus) {
        this.cmsPsuPisService.updatePaymentStatus(paymentId, TransactionStatus.valueOf((String)transactionStatus), "UNDEFINED");
    }

    private void updateConsentStatus(GlobalScaResponseTO response) {
        if (response.isPartiallyAuthorised()) {
            this.cmsPsuAisClient.authorisePartiallyConsent(response.getOperationObjectId(), "UNDEFINED");
        } else {
            this.cmsPsuAisClient.confirmConsent(response.getOperationObjectId(), "UNDEFINED");
        }
    }

    private void updateAspspConsentData(GlobalScaResponseTO scaResponse) {
        CmsAspspConsentDataBase64 consentData = new CmsAspspConsentDataBase64(scaResponse.getOperationObjectId(), this.dataService.toBase64String((Object)scaResponse));
        this.aspspConsentDataClient.updateAspspConsentData(scaResponse.getExternalId(), consentData);
    }

    public DecoupledServiceImpl(KeycloakTokenService tokenService, AuthRequestInterceptor authInterceptor, OperationInitiationRestClient operationInitiationRestClient, RedirectScaRestClient redirectScaClient, CmsPsuPisService cmsPsuPisService, CmsPsuAisClient cmsPsuAisClient, CmsAspspConsentDataService dataService, AspspConsentDataClient aspspConsentDataClient) {
        this.tokenService = tokenService;
        this.authInterceptor = authInterceptor;
        this.operationInitiationRestClient = operationInitiationRestClient;
        this.redirectScaClient = redirectScaClient;
        this.cmsPsuPisService = cmsPsuPisService;
        this.cmsPsuAisClient = cmsPsuAisClient;
        this.dataService = dataService;
        this.aspspConsentDataClient = aspspConsentDataClient;
    }
}

