/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ObaAisConsentMapper {
    public AisConsentTO toTo(CmsAisAccountConsent consent) {
        return new AisConsentTO(consent.getId(), this.resolveUserId(consent.getPsuIdDataList()), (String)Optional.ofNullable(consent.getTppInfo()).map(TppInfo::getAuthorisationNumber).orElse(null), consent.getFrequencyPerDay(), this.toAccess(consent.getAccess()), consent.getValidUntil(), consent.isRecurringIndicator());
    }

    private AisAccountAccessInfoTO toAccess(AisAccountAccess access) {
        return new AisAccountAccessInfoTO(this.getIbansFromAccountReference(access.getAccounts()), this.getIbansFromAccountReference(access.getBalances()), this.getIbansFromAccountReference(access.getTransactions()), this.mapAccessType(access.getAvailableAccounts()), this.mapAccessType(access.getAllPsd2()));
    }

    private AisAccountAccessTypeTO mapAccessType(String accessType) {
        return Optional.ofNullable(accessType).map(AisAccountAccessTypeTO::valueOf).orElse(null);
    }

    public AisAccountAccess accountAccess(AisAccountAccessInfoTO access, List<AccountDetailsTO> accountDetails) {
        List<AccountReference> accounts = this.mapToAccountReference(access.getAccounts(), accountDetails);
        List<AccountReference> balances = this.mapToAccountReference(access.getBalances(), accountDetails);
        List<AccountReference> transactions = this.mapToAccountReference(access.getTransactions(), accountDetails);
        String availableAccounts = Optional.ofNullable(access.getAvailableAccounts()).map(Enum::name).orElse(null);
        String allPsd2 = Optional.ofNullable(access.getAllPsd2()).map(Enum::name).orElse(null);
        return new AisAccountAccess(accounts, balances, transactions, availableAccounts, allPsd2, null, null);
    }

    private List<AccountReference> mapToAccountReference(List<String> ibans, List<AccountDetailsTO> accountDetails) {
        return ibans == null ? null : ibans.stream().map(iban -> this.toAccountReference((String)iban, accountDetails)).collect(Collectors.toList());
    }

    private AccountReference toAccountReference(String iban, List<AccountDetailsTO> accountDetails) {
        return accountDetails.stream().filter(a -> a.getIban().equals(iban)).findFirst().map(this::accountDetail2Reference).orElse(null);
    }

    private AccountReference accountDetail2Reference(AccountDetailsTO ad) {
        AccountReference a = new AccountReference();
        a.setAspspAccountId(ad.getId());
        a.setBban(ad.getBban());
        a.setCurrency(ad.getCurrency());
        a.setIban(ad.getIban());
        a.setMaskedPan(ad.getMaskedPan());
        a.setMsisdn(ad.getMsisdn());
        a.setPan(ad.getPan());
        return a;
    }

    private String resolveUserId(List<PsuIdData> psuIdDataList) {
        if (CollectionUtils.isEmpty(psuIdDataList)) {
            return null;
        }
        return this.getFirstPsu(psuIdDataList).getPsuId();
    }

    private PsuIdData getFirstPsu(List<PsuIdData> psuIdDataList) {
        return psuIdDataList.get(0);
    }

    private List<String> getIbansFromAccountReference(List<AccountReference> references) {
        return Optional.ofNullable(references).map(this::mapAccountReferencesToString).orElse(null);
    }

    private List<String> mapAccountReferencesToString(List<AccountReference> references) {
        return references.stream().map(AccountReference::getIban).collect(Collectors.toList());
    }
}

