/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.UserMgmtRestClient;
import de.adorsys.ledgers.oba.service.api.domain.UserAuthentication;
import de.adorsys.ledgers.oba.service.api.service.TokenAuthenticationService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthenticationServiceImpl
implements TokenAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationServiceImpl.class);
    private final UserMgmtRestClient ledgersUserMgmt;
    private final AuthRequestInterceptor authInterceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAuthentication getAuthentication(String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        BearerTokenTO bearerToken = null;
        try {
            this.authInterceptor.setAccessToken(accessToken);
            ResponseEntity responseEntity = this.ledgersUserMgmt.validate(accessToken);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                bearerToken = (BearerTokenTO)responseEntity.getBody();
            }
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
        if (bearerToken == null) {
            this.debug("Token is not valid.");
            return null;
        }
        return new UserAuthentication(bearerToken);
    }

    private void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug(s);
        }
    }

    public TokenAuthenticationServiceImpl(UserMgmtRestClient ledgersUserMgmt, AuthRequestInterceptor authInterceptor) {
        this.ledgersUserMgmt = ledgersUserMgmt;
        this.authInterceptor = authInterceptor;
    }
}

