/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import java.io.IOException;
import java.util.Base64;
import org.springframework.stereotype.Service;

@Service
public class TokenStorageServiceImpl
implements TokenStorageService {
    private final ObjectMapper mapper;

    public SCAResponseTO fromBytes(byte[] tokenBytes) throws IOException {
        if (tokenBytes == null) {
            return null;
        }
        return this.read(tokenBytes);
    }

    public byte[] toBytes(SCAResponseTO response) throws IOException {
        return this.mapper.writeValueAsBytes((Object)response);
    }

    public <T extends SCAResponseTO> T fromBytes(byte[] tokenBytes, Class<T> klass) throws IOException {
        return this.read(tokenBytes, klass);
    }

    public String toBase64String(SCAResponseTO response) throws IOException {
        return Base64.getEncoder().encodeToString(this.toBytes(response));
    }

    private SCAResponseTO read(byte[] tokenBytes) throws IOException {
        JsonNode jsonNode = this.prepareNode(tokenBytes);
        String type = this.objectType(jsonNode);
        JsonParser jsonParser = this.mapper.treeAsTokens((TreeNode)jsonNode);
        if (SCAConsentResponseTO.class.getSimpleName().equals(type)) {
            return (SCAResponseTO)this.mapper.readValue(jsonParser, SCAConsentResponseTO.class);
        }
        if (SCALoginResponseTO.class.getSimpleName().equals(type)) {
            return (SCAResponseTO)this.mapper.readValue(jsonParser, SCALoginResponseTO.class);
        }
        if (SCAPaymentResponseTO.class.getSimpleName().equals(type)) {
            return (SCAResponseTO)this.mapper.readValue(jsonParser, SCAPaymentResponseTO.class);
        }
        throw new IOException("Unknown response type " + type);
    }

    private <T extends SCAResponseTO> T read(byte[] tokenBytes, Class<T> klass) throws IOException {
        JsonNode jsonNode = this.prepareNode(tokenBytes);
        JsonParser jsonParser = this.mapper.treeAsTokens((TreeNode)jsonNode);
        return (T)((SCAResponseTO)this.mapper.readValue(jsonParser, klass));
    }

    private JsonNode prepareNode(byte[] tokenBytes) throws IOException {
        JsonNode jsonNode = this.mapper.readTree(tokenBytes);
        if (jsonNode.size() == 1) {
            jsonNode = (JsonNode)jsonNode.iterator().next();
        }
        return jsonNode;
    }

    private String objectType(JsonNode jsonNode) {
        JsonNode objectType = jsonNode.get("objectType");
        return objectType != null ? objectType.asText() : null;
    }

    public TokenStorageServiceImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

