package de.adorsys.ledgers.oba.service.impl.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsBulkPayment;
import de.adorsys.psd2.consent.api.pis.CmsPeriodicPayment;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import de.adorsys.psd2.xs2a.core.pis.FrequencyCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-04-24T06:50:36+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class PaymentMapperImpl implements PaymentMapper {

    @Autowired
    private TimeMapper timeMapper;

    @Override
    public SinglePaymentTO toPayment(CmsSinglePayment payment) {
        if ( payment == null ) {
            return null;
        }

        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();

        singlePaymentTO.setPaymentId( payment.getPaymentId() );
        singlePaymentTO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        singlePaymentTO.setDebtorAccount( accountReferenceToAccountReferenceTO( payment.getDebtorAccount() ) );
        singlePaymentTO.setInstructedAmount( cmsAmountToAmountTO( payment.getInstructedAmount() ) );
        singlePaymentTO.setCreditorAccount( accountReferenceToAccountReferenceTO( payment.getCreditorAccount() ) );
        singlePaymentTO.setCreditorAgent( payment.getCreditorAgent() );
        singlePaymentTO.setCreditorName( payment.getCreditorName() );
        singlePaymentTO.setCreditorAddress( cmsAddressToAddressTO( payment.getCreditorAddress() ) );
        singlePaymentTO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        singlePaymentTO.setPaymentStatus( toTransactionStatusTO( payment.getPaymentStatus() ) );
        singlePaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        singlePaymentTO.setRequestedExecutionTime( timeMapper.mapTime( payment.getRequestedExecutionTime() ) );

        singlePaymentTO.setPaymentProduct( mapToPaymentProduct(payment.getPaymentProduct()) );

        return singlePaymentTO;
    }

    @Override
    public PeriodicPaymentTO toPayment(CmsPeriodicPayment payment) {
        if ( payment == null ) {
            return null;
        }

        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();

        periodicPaymentTO.setPaymentId( payment.getPaymentId() );
        periodicPaymentTO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        periodicPaymentTO.setDebtorAccount( accountReferenceToAccountReferenceTO( payment.getDebtorAccount() ) );
        periodicPaymentTO.setInstructedAmount( cmsAmountToAmountTO( payment.getInstructedAmount() ) );
        periodicPaymentTO.setCreditorAccount( accountReferenceToAccountReferenceTO( payment.getCreditorAccount() ) );
        periodicPaymentTO.setCreditorAgent( payment.getCreditorAgent() );
        periodicPaymentTO.setCreditorName( payment.getCreditorName() );
        periodicPaymentTO.setCreditorAddress( cmsAddressToAddressTO( payment.getCreditorAddress() ) );
        periodicPaymentTO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        periodicPaymentTO.setPaymentStatus( toTransactionStatusTO( payment.getPaymentStatus() ) );
        periodicPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        periodicPaymentTO.setRequestedExecutionTime( timeMapper.mapTime( payment.getRequestedExecutionTime() ) );
        periodicPaymentTO.setStartDate( payment.getStartDate() );
        periodicPaymentTO.setEndDate( payment.getEndDate() );
        periodicPaymentTO.setFrequency( frequencyCodeToFrequencyCodeTO( payment.getFrequency() ) );

        periodicPaymentTO.setExecutionRule( mapPisExecutionRule(payment.getExecutionRule()) );
        periodicPaymentTO.setPaymentProduct( mapToPaymentProduct(payment.getPaymentProduct()) );
        periodicPaymentTO.setDayOfExecution( mapPisDayOfExecution(payment.getDayOfExecution()) );

        return periodicPaymentTO;
    }

    @Override
    public BulkPaymentTO toPayment(CmsBulkPayment payment) {
        if ( payment == null ) {
            return null;
        }

        BulkPaymentTO bulkPaymentTO = new BulkPaymentTO();

        bulkPaymentTO.setPaymentId( payment.getPaymentId() );
        bulkPaymentTO.setBatchBookingPreferred( payment.isBatchBookingPreferred() );
        bulkPaymentTO.setDebtorAccount( accountReferenceToAccountReferenceTO( payment.getDebtorAccount() ) );
        bulkPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        bulkPaymentTO.setPaymentStatus( toTransactionStatusTO( payment.getPaymentStatus() ) );
        bulkPaymentTO.setPayments( cmsSinglePaymentListToSinglePaymentTOList( payment.getPayments() ) );

        bulkPaymentTO.setPaymentProduct( mapToPaymentProduct(payment.getPaymentProduct()) );

        return bulkPaymentTO;
    }

    @Override
    public TransactionStatusTO toTransactionStatusTO(TransactionStatus status) {
        if ( status == null ) {
            return null;
        }

        TransactionStatusTO transactionStatusTO;

        switch ( status ) {
            case ACCC: transactionStatusTO = TransactionStatusTO.ACCC;
            break;
            case ACCP: transactionStatusTO = TransactionStatusTO.ACCP;
            break;
            case ACSC: transactionStatusTO = TransactionStatusTO.ACSC;
            break;
            case ACSP: transactionStatusTO = TransactionStatusTO.ACSP;
            break;
            case ACTC: transactionStatusTO = TransactionStatusTO.ACTC;
            break;
            case ACWC: transactionStatusTO = TransactionStatusTO.ACWC;
            break;
            case ACWP: transactionStatusTO = TransactionStatusTO.ACWP;
            break;
            case RCVD: transactionStatusTO = TransactionStatusTO.RCVD;
            break;
            case PDNG: transactionStatusTO = TransactionStatusTO.PDNG;
            break;
            case RJCT: transactionStatusTO = TransactionStatusTO.RJCT;
            break;
            case CANC: transactionStatusTO = TransactionStatusTO.CANC;
            break;
            case ACFC: transactionStatusTO = TransactionStatusTO.ACFC;
            break;
            case PATC: transactionStatusTO = TransactionStatusTO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + status );
        }

        return transactionStatusTO;
    }

    protected AccountReferenceTO accountReferenceToAccountReferenceTO(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( accountReference.getIban() );
        accountReferenceTO.setBban( accountReference.getBban() );
        accountReferenceTO.setPan( accountReference.getPan() );
        accountReferenceTO.setMaskedPan( accountReference.getMaskedPan() );
        accountReferenceTO.setMsisdn( accountReference.getMsisdn() );
        accountReferenceTO.setCurrency( accountReference.getCurrency() );

        return accountReferenceTO;
    }

    protected AmountTO cmsAmountToAmountTO(CmsAmount cmsAmount) {
        if ( cmsAmount == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( cmsAmount.getCurrency() );
        amountTO.setAmount( cmsAmount.getAmount() );

        return amountTO;
    }

    protected AddressTO cmsAddressToAddressTO(CmsAddress cmsAddress) {
        if ( cmsAddress == null ) {
            return null;
        }

        AddressTO addressTO = new AddressTO();

        addressTO.setStreet( cmsAddress.getStreet() );
        addressTO.setBuildingNumber( cmsAddress.getBuildingNumber() );
        addressTO.setCity( cmsAddress.getCity() );
        addressTO.setPostalCode( cmsAddress.getPostalCode() );
        addressTO.setCountry( cmsAddress.getCountry() );

        return addressTO;
    }

    protected FrequencyCodeTO frequencyCodeToFrequencyCodeTO(FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        FrequencyCodeTO frequencyCodeTO;

        switch ( frequencyCode ) {
            case DAILY: frequencyCodeTO = FrequencyCodeTO.DAILY;
            break;
            case WEEKLY: frequencyCodeTO = FrequencyCodeTO.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCodeTO = FrequencyCodeTO.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCodeTO = FrequencyCodeTO.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCodeTO = FrequencyCodeTO.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return frequencyCodeTO;
    }

    protected List<SinglePaymentTO> cmsSinglePaymentListToSinglePaymentTOList(List<CmsSinglePayment> list) {
        if ( list == null ) {
            return null;
        }

        List<SinglePaymentTO> list1 = new ArrayList<SinglePaymentTO>( list.size() );
        for ( CmsSinglePayment cmsSinglePayment : list ) {
            list1.add( toPayment( cmsSinglePayment ) );
        }

        return list1;
    }
}
