/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.ConsentRestClient;
import de.adorsys.ledgers.oba.service.api.domain.CreatePiisConsentRequestTO;
import de.adorsys.ledgers.oba.service.api.domain.ObaAisConsent;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.ConsentService;
import de.adorsys.ledgers.oba.service.impl.mapper.CreatePiisConsentRequestMapper;
import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import feign.FeignException;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adorsys.ledgers.consent.aspsp.rest.client.CmsAspspPiisClient;
import org.adorsys.ledgers.consent.aspsp.rest.client.CreatePiisConsentRequest;
import org.adorsys.ledgers.consent.aspsp.rest.client.CreatePiisConsentResponse;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuAisClient;
import org.adorsys.ledgers.consent.xs2a.rest.client.AspspConsentDataClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConsentServiceImpl
implements ConsentService {
    private static final Logger log = LoggerFactory.getLogger(ConsentServiceImpl.class);
    private static final String RESPONSE_ERROR = "Error in response from CMS, please contact admin.";
    private static final String GET_CONSENTS_ERROR_MSG = "Failed to retrieve consents for user: %s, code: %s, message: %s";
    private static final String CONSENT_COULD_NOT_BE_FOUND = "Consent %s could not be found";
    private static final String FAILED_TO_CONFIRM_THE_CONSENT_MSG = "Failed to confirm the consent %s msg: %s";
    private static final String UPDATE_FAILED_MSG = "Update %s failed msg: %s";
    private static final String COULD_NOT_RETRIEVE_ASPSP_CONSENT_DATA = "Could not retrieve ASPSP consent data.";
    private static final String DEFAULT_SERVICE_INSTANCE_ID = "UNDEFINED";
    private final CmsPsuAisClient cmsPsuAisClient;
    private final SecurityDataService securityDataService;
    private final AspspConsentDataClient consentDataClient;
    private final ConsentRestClient consentRestClient;
    private final AuthRequestInterceptor authInterceptor;
    private final ObjectMapper objectMapper;
    private final AspspDataService aspspDataService;
    private final CmsAspspPiisClient cmsAspspPiisClient;
    private final CreatePiisConsentRequestMapper createPiisConsentRequestMapper;

    public List<ObaAisConsent> getListOfConsents(String userLogin) {
        try {
            List<CmsAisAccountConsent> aisAccountConsents = Optional.ofNullable((List)this.cmsPsuAisClient.getConsentsForPsu(userLogin, null, null, null, DEFAULT_SERVICE_INSTANCE_ID).getBody()).orElse(Collections.emptyList());
            return this.toObaAisConsent(aisAccountConsents);
        }
        catch (FeignException e) {
            String msg = String.format(GET_CONSENTS_ERROR_MSG, userLogin, e.status(), e.getMessage());
            log.error(msg);
            throw ObaException.builder().devMessage(RESPONSE_ERROR).obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build();
        }
    }

    public boolean revokeConsent(String consentId) {
        return Optional.ofNullable((Boolean)this.cmsPsuAisClient.revokeConsent(consentId, null, null, null, null, DEFAULT_SERVICE_INSTANCE_ID).getBody()).orElse(false);
    }

    public void confirmAisConsentDecoupled(String userLogin, String encryptedConsentId, String authorizationId, String tan) {
        String consentId = this.getDecryptedConsentId(encryptedConsentId);
        this.setActiveAccessTokenFromConsentData(encryptedConsentId);
        SCAConsentResponseTO ledgerValidateTanConsentResponse = this.authorizeConsentAtLedgers(consentId, authorizationId, tan);
        this.confirmConsentAtCms(userLogin, consentId);
        this.updateCmsAuthorization(userLogin, authorizationId, consentId);
        this.updateAspspConsentDataForConsent(encryptedConsentId, ledgerValidateTanConsentResponse);
        this.authInterceptor.setAccessToken(null);
    }

    public SCAConsentResponseTO createConsent(CreatePiisConsentRequestTO request, String psuId) {
        CreatePiisConsentRequest piisConsentRequest = this.createPiisConsentRequestMapper.fromCreatePiisConsentRequest(request);
        CreatePiisConsentResponse cmsConsent = (CreatePiisConsentResponse)this.cmsAspspPiisClient.createConsent(piisConsentRequest, psuId, null, null, null).getBody();
        String consentId = Optional.ofNullable(cmsConsent).orElseGet(CreatePiisConsentResponse::new).getConsentId();
        AisConsentTO pisConsent = new AisConsentTO(consentId, psuId, piisConsentRequest.getTppAuthorisationNumber(), 100, this.buildAccountAccess(piisConsentRequest.getAccount().getIban()), piisConsentRequest.getValidUntil(), true);
        return (SCAConsentResponseTO)this.consentRestClient.grantPIISConsent(pisConsent).getBody();
    }

    private AisAccountAccessInfoTO buildAccountAccess(String iban) {
        AisAccountAccessInfoTO access = new AisAccountAccessInfoTO();
        access.setAccounts(Collections.singletonList(iban));
        return access;
    }

    private void updateCmsAuthorization(String userLogin, String authorizationId, String consentId) {
        try {
            this.cmsPsuAisClient.updateAuthorisationStatus(consentId, "FINALISED", authorizationId, userLogin, null, null, null, DEFAULT_SERVICE_INSTANCE_ID, new AuthenticationDataHolder(null, null));
        }
        catch (FeignException e) {
            String msg = String.format(UPDATE_FAILED_MSG, "authorization", e.getMessage());
            log.error(msg);
            throw ObaException.builder().devMessage(msg).obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build();
        }
    }

    private void updateAspspConsentDataForConsent(String encryptedConsentId, SCAConsentResponseTO ledgerValidateTanConsentResponse) {
        CmsAspspConsentDataBase64 updatedConsentData = new CmsAspspConsentDataBase64(encryptedConsentId, this.writeScaResponseAsString((SCAResponseTO)ledgerValidateTanConsentResponse));
        try {
            this.consentDataClient.updateAspspConsentData(encryptedConsentId, updatedConsentData);
        }
        catch (FeignException e) {
            String msg = String.format(UPDATE_FAILED_MSG, "aspsp consent data", e.getMessage());
            log.error(msg);
            throw ObaException.builder().devMessage(msg).obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build();
        }
    }

    private void confirmConsentAtCms(String userLogin, String consentId) {
        try {
            this.cmsPsuAisClient.confirmConsent(consentId, userLogin, null, null, null, DEFAULT_SERVICE_INSTANCE_ID).getBody();
        }
        catch (FeignException e) {
            String msg = e.status() == 404 ? String.format(CONSENT_COULD_NOT_BE_FOUND, consentId) : String.format(FAILED_TO_CONFIRM_THE_CONSENT_MSG, consentId, e.getMessage());
            log.error(msg);
            ObaErrorCode errorCode = e.status() == 404 ? ObaErrorCode.NOT_FOUND : ObaErrorCode.CONNECTION_ERROR;
            throw ObaException.builder().devMessage(msg).obaErrorCode(errorCode).build();
        }
    }

    private String getDecryptedConsentId(String encryptedConsentId) {
        return (String)this.securityDataService.decryptId(encryptedConsentId).orElseThrow(() -> ObaException.builder().devMessage("Error decrypting consent id").obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build());
    }

    private String writeScaResponseAsString(SCAResponseTO ledgerValidateTanConsentResponse) {
        try {
            return Base64.getEncoder().encodeToString(this.objectMapper.writeValueAsBytes((Object)ledgerValidateTanConsentResponse));
        }
        catch (JsonProcessingException e) {
            throw ObaException.builder().devMessage("Could not encode ledgers consent confirmation response.").obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build();
        }
    }

    private SCAConsentResponseTO authorizeConsentAtLedgers(String consentId, String authorizationId, String tan) {
        try {
            return (SCAConsentResponseTO)this.consentRestClient.authorizeConsent(consentId, authorizationId, tan).getBody();
        }
        catch (FeignException e) {
            throw ObaException.builder().devMessage(this.getDevMessageFromFeignException(e)).obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build();
        }
    }

    private String getDevMessageFromFeignException(FeignException e) {
        try {
            return this.objectMapper.readTree(e.content()).get("devMessage").asText();
        }
        catch (IOException i) {
            return "Could not extract exception message from ASPSP response";
        }
    }

    private void setActiveAccessTokenFromConsentData(String encryptedConsentId) {
        String token;
        try {
            byte[] decodedData = this.aspspDataService.readAspspConsentData(encryptedConsentId).map(AspspConsentData::getAspspConsentData).orElseThrow(() -> ObaException.builder().devMessage(COULD_NOT_RETRIEVE_ASPSP_CONSENT_DATA).obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build());
            token = Optional.ofNullable(this.objectMapper.readTree(decodedData).get("bearerToken")).map(t -> t.get("access_token")).map(JsonNode::asText).orElseThrow(() -> ObaException.builder().devMessage("No AccessToken present in ASPSP consent data").obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build());
        }
        catch (IOException e) {
            throw ObaException.builder().devMessage("Could not parse ASPSP consent data").obaErrorCode(ObaErrorCode.AIS_BAD_REQUEST).build();
        }
        this.authInterceptor.setAccessToken(token);
    }

    private List<ObaAisConsent> toObaAisConsent(List<CmsAisAccountConsent> aisAccountConsents) {
        return aisAccountConsents.stream().map(a -> new ObaAisConsent(this.securityDataService.encryptId(a.getId()).orElse(""), a)).collect(Collectors.toList());
    }

    public ConsentServiceImpl(CmsPsuAisClient cmsPsuAisClient, SecurityDataService securityDataService, AspspConsentDataClient consentDataClient, ConsentRestClient consentRestClient, AuthRequestInterceptor authInterceptor, ObjectMapper objectMapper, AspspDataService aspspDataService, CmsAspspPiisClient cmsAspspPiisClient, CreatePiisConsentRequestMapper createPiisConsentRequestMapper) {
        this.cmsPsuAisClient = cmsPsuAisClient;
        this.securityDataService = securityDataService;
        this.consentDataClient = consentDataClient;
        this.consentRestClient = consentRestClient;
        this.authInterceptor = authInterceptor;
        this.objectMapper = objectMapper;
        this.aspspDataService = aspspDataService;
        this.cmsAspspPiisClient = cmsAspspPiisClient;
        this.createPiisConsentRequestMapper = createPiisConsentRequestMapper;
    }
}

