/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.service;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.ConsentRestClient;
import de.adorsys.ledgers.oba.service.api.domain.ConsentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.ConsentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.AuthorizationException;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import de.adorsys.ledgers.oba.service.api.service.RedirectConsentService;
import de.adorsys.ledgers.oba.service.impl.mapper.ObaAisConsentMapper;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.consent.psu.api.ais.CmsAisConsentAccessRequest;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuAisClient;
import org.adorsys.ledgers.consent.xs2a.rest.client.AspspConsentDataClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class RedirectConsentServiceImpl
implements RedirectConsentService {
    private final CmsPsuAisClient cmsPsuAisClient;
    private final ConsentRestClient consentRestClient;
    private final AuthRequestInterceptor authInterceptor;
    private final ObaAisConsentMapper consentMapper;
    private final ConsentReferencePolicy referencePolicy;
    private final TokenStorageService tokenStorageService;
    private final AspspConsentDataClient aspspConsentDataClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectScaMethod(String scaMethodId, ConsentWorkflow workflow) {
        try {
            this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
            BearerTokenTO bearerToken = workflow.bearerToken();
            SCAConsentResponseTO sca = (SCAConsentResponseTO)this.consentRestClient.selectMethod(workflow.consentId(), workflow.authId(), scaMethodId).getBody();
            sca.setBearerToken(bearerToken);
            workflow.storeSCAResponse((SCAResponseTO)sca);
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
    }

    public void updateAccessByConsentType(ConsentWorkflow workflow, List<AccountDetailsTO> listOfAccounts) {
        AisConsentRequestType consentType = workflow.getConsentResponse().getAccountConsent().getAisConsentRequestType();
        if (!EnumSet.of(AisConsentRequestType.BANK_OFFERED, AisConsentRequestType.DEDICATED_ACCOUNTS).contains(consentType)) {
            AisAccountAccessInfoTO authAccountAccess = workflow.getAuthResponse().getConsent().getAccess();
            List<String> ibans = this.extractUserIbans(listOfAccounts);
            authAccountAccess.setAccounts(ibans);
            if (AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS == consentType && this.requestedConsentWithBalance(workflow)) {
                authAccountAccess.setBalances(ibans);
            }
            if (AisConsentRequestType.GLOBAL == consentType) {
                authAccountAccess.setBalances(ibans);
                authAccountAccess.setTransactions(ibans);
            }
        }
        if (AisConsentRequestType.DEDICATED_ACCOUNTS == consentType) {
            HashSet<String> ibans = new HashSet<String>(this.extractUserIbans(listOfAccounts));
            Set<String> ibansFromAccess = this.extractIbansFromAccess(workflow.getConsentResponse().getAccountConsent().getAccess());
            this.checkAccess(ibansFromAccess, ibans);
        }
    }

    private void checkAccess(Set<String> ibansFromAccess, Set<String> ibans) {
        if (!ibans.containsAll(ibansFromAccess)) {
            throw AuthorizationException.builder().errorCode(AuthErrorCode.LOGIN_FAILED).devMessage("Operation you're logging in is not meant for current user").build();
        }
    }

    private Set<String> extractIbansFromAccess(AisAccountAccess access) {
        return Stream.of(access.getAccounts(), access.getBalances(), access.getTransactions()).flatMap(a -> a.stream().map(AccountReference::getIban)).collect(Collectors.toSet());
    }

    private List<String> extractUserIbans(List<AccountDetailsTO> accounts) {
        return accounts.stream().map(AccountDetailsTO::getIban).collect(Collectors.toList());
    }

    public void updateScaStatusConsentStatusConsentData(String psuId, ConsentWorkflow workflow) {
        this.updateCmsAuthorizationScaStatus(workflow, psuId);
        this.updateAspspConsentData(workflow);
    }

    private void updateCmsAuthorizationScaStatus(ConsentWorkflow workflow, String psuId) {
        String status = workflow.getAuthResponse().getScaStatus().name();
        this.cmsPsuAisClient.updateAuthorisationStatus(workflow.consentId(), status, workflow.authId(), psuId, null, null, null, "UNDEFINED", new AuthenticationDataHolder(null, null));
    }

    private void updateAspspConsentData(ConsentWorkflow workflow) {
        CmsAspspConsentDataBase64 consentData;
        try {
            consentData = new CmsAspspConsentDataBase64(workflow.consentId(), this.tokenStorageService.toBase64String(workflow.getScaResponse()));
        }
        catch (IOException e) {
            throw AuthorizationException.builder().errorCode(AuthErrorCode.CONSENT_DATA_UPDATE_FAILED).devMessage("Consent data update failed").build();
        }
        this.aspspConsentDataClient.updateAspspConsentData(workflow.getConsentReference().getEncryptedConsentId(), consentData);
    }

    public void startConsent(ConsentWorkflow workflow, AisConsentTO aisConsent, List<AccountDetailsTO> listOfAccounts) {
        AisAccountAccess accountAccess = this.consentMapper.accountAccess(aisConsent.getAccess(), listOfAccounts);
        CmsAisConsentAccessRequest accountAccessRequest = new CmsAisConsentAccessRequest(accountAccess, aisConsent.getValidUntil(), aisConsent.getFrequencyPerDay(), Boolean.valueOf(false), Boolean.valueOf(aisConsent.isRecurringIndicator()));
        this.cmsPsuAisClient.putAccountAccessInConsent(workflow.consentId(), accountAccessRequest, "UNDEFINED");
        AisConsentTO consent = this.consentMapper.toTo(workflow.getConsentResponse().getAccountConsent());
        consent.setAccess(aisConsent.getAccess());
        workflow.getAuthResponse().setConsent(consent);
        this.authInterceptor.setAccessToken(workflow.bearerToken().getAccess_token());
        SCAConsentResponseTO sca = (SCAConsentResponseTO)this.consentRestClient.startSCA(workflow.consentId(), consent).getBody();
        sca.setBearerToken(workflow.bearerToken());
        workflow.storeSCAResponse((SCAResponseTO)sca);
    }

    public ConsentWorkflow identifyConsent(String encryptedConsentId, String authorizationId, boolean strict, String consentCookieString, BearerTokenTO bearerToken) {
        ConsentReference consentReference = this.referencePolicy.fromRequest(encryptedConsentId, authorizationId, consentCookieString, strict);
        CmsAisConsentResponse cmsConsentResponse = this.loadConsentByRedirectId(consentReference);
        ConsentWorkflow workflow = new ConsentWorkflow(cmsConsentResponse, consentReference);
        AisConsentTO aisConsentTO = this.consentMapper.toTo(cmsConsentResponse.getAccountConsent());
        workflow.setAuthResponse(new ConsentAuthorizeResponse(aisConsentTO));
        workflow.getAuthResponse().setAuthorisationId(cmsConsentResponse.getAuthorisationId());
        workflow.getAuthResponse().setEncryptedConsentId(encryptedConsentId);
        if (bearerToken != null) {
            SCAConsentResponseTO scaConsentResponseTO = new SCAConsentResponseTO();
            scaConsentResponseTO.setBearerToken(bearerToken);
            workflow.setScaResponse((SCAResponseTO)scaConsentResponseTO);
        }
        return workflow;
    }

    private CmsAisConsentResponse loadConsentByRedirectId(ConsentReference consentReference) {
        String redirectId = consentReference.getRedirectId();
        ResponseEntity responseEntity = this.cmsPsuAisClient.getConsentIdByRedirectId(redirectId, "UNDEFINED");
        return (CmsAisConsentResponse)responseEntity.getBody();
    }

    private boolean requestedConsentWithBalance(ConsentWorkflow workflow) {
        return StringUtils.isNotBlank((CharSequence)workflow.getConsentResponse().getAccountConsent().getAccess().getAvailableAccountsWithBalance());
    }

    public RedirectConsentServiceImpl(CmsPsuAisClient cmsPsuAisClient, ConsentRestClient consentRestClient, AuthRequestInterceptor authInterceptor, ObaAisConsentMapper consentMapper, ConsentReferencePolicy referencePolicy, TokenStorageService tokenStorageService, AspspConsentDataClient aspspConsentDataClient) {
        this.cmsPsuAisClient = cmsPsuAisClient;
        this.consentRestClient = consentRestClient;
        this.authInterceptor = authInterceptor;
        this.consentMapper = consentMapper;
        this.referencePolicy = referencePolicy;
        this.tokenStorageService = tokenStorageService;
        this.aspspConsentDataClient = aspspConsentDataClient;
    }
}

