/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.impl.mapper;

import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.oba.service.impl.mapper.PaymentMapper;
import de.adorsys.ledgers.oba.service.impl.mapper.TimeMapper;
import de.adorsys.psd2.consent.api.CmsAddress;
import de.adorsys.psd2.consent.api.ais.CmsAccountReference;
import de.adorsys.psd2.consent.api.pis.CmsAmount;
import de.adorsys.psd2.consent.api.pis.CmsBulkPayment;
import de.adorsys.psd2.consent.api.pis.CmsPeriodicPayment;
import de.adorsys.psd2.consent.api.pis.CmsSinglePayment;
import de.adorsys.psd2.xs2a.core.pis.FrequencyCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentMapperImpl
implements PaymentMapper {
    @Autowired
    private TimeMapper timeMapper;

    @Override
    public SinglePaymentTO toPayment(CmsSinglePayment payment) {
        if (payment == null) {
            return null;
        }
        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();
        singlePaymentTO.setPaymentId(payment.getPaymentId());
        singlePaymentTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        singlePaymentTO.setDebtorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        singlePaymentTO.setInstructedAmount(this.cmsAmountToAmountTO(payment.getInstructedAmount()));
        singlePaymentTO.setCreditorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getCreditorAccount()));
        singlePaymentTO.setCreditorAgent(payment.getCreditorAgent());
        singlePaymentTO.setCreditorName(payment.getCreditorName());
        singlePaymentTO.setCreditorAddress(this.cmsAddressToAddressTO(payment.getCreditorAddress()));
        singlePaymentTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        singlePaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        singlePaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        singlePaymentTO.setRequestedExecutionTime(this.timeMapper.mapTime(payment.getRequestedExecutionTime()));
        singlePaymentTO.setPaymentProduct(this.mapToPaymentProduct(payment.getPaymentProduct()));
        return singlePaymentTO;
    }

    @Override
    public PeriodicPaymentTO toPayment(CmsPeriodicPayment payment) {
        if (payment == null) {
            return null;
        }
        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();
        periodicPaymentTO.setPaymentId(payment.getPaymentId());
        periodicPaymentTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodicPaymentTO.setDebtorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        periodicPaymentTO.setInstructedAmount(this.cmsAmountToAmountTO(payment.getInstructedAmount()));
        periodicPaymentTO.setCreditorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getCreditorAccount()));
        periodicPaymentTO.setCreditorAgent(payment.getCreditorAgent());
        periodicPaymentTO.setCreditorName(payment.getCreditorName());
        periodicPaymentTO.setCreditorAddress(this.cmsAddressToAddressTO(payment.getCreditorAddress()));
        periodicPaymentTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodicPaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        periodicPaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        periodicPaymentTO.setRequestedExecutionTime(this.timeMapper.mapTime(payment.getRequestedExecutionTime()));
        periodicPaymentTO.setStartDate(payment.getStartDate());
        periodicPaymentTO.setEndDate(payment.getEndDate());
        periodicPaymentTO.setFrequency(this.frequencyCodeToFrequencyCodeTO(payment.getFrequency()));
        periodicPaymentTO.setExecutionRule(this.mapPisExecutionRule(payment.getExecutionRule()));
        periodicPaymentTO.setPaymentProduct(this.mapToPaymentProduct(payment.getPaymentProduct()));
        periodicPaymentTO.setDayOfExecution(Integer.valueOf(this.mapPisDayOfExecution(payment.getDayOfExecution())));
        return periodicPaymentTO;
    }

    @Override
    public BulkPaymentTO toPayment(CmsBulkPayment payment) {
        if (payment == null) {
            return null;
        }
        BulkPaymentTO bulkPaymentTO = new BulkPaymentTO();
        bulkPaymentTO.setPaymentId(payment.getPaymentId());
        bulkPaymentTO.setBatchBookingPreferred(Boolean.valueOf(payment.isBatchBookingPreferred()));
        bulkPaymentTO.setDebtorAccount(this.cmsAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        bulkPaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        bulkPaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        bulkPaymentTO.setPayments(this.cmsSinglePaymentListToSinglePaymentTOList(payment.getPayments()));
        bulkPaymentTO.setPaymentProduct(this.mapToPaymentProduct(payment.getPaymentProduct()));
        return bulkPaymentTO;
    }

    protected AccountReferenceTO cmsAccountReferenceToAccountReferenceTO(CmsAccountReference cmsAccountReference) {
        if (cmsAccountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(cmsAccountReference.getIban());
        accountReferenceTO.setBban(cmsAccountReference.getBban());
        accountReferenceTO.setPan(cmsAccountReference.getPan());
        accountReferenceTO.setMaskedPan(cmsAccountReference.getMaskedPan());
        accountReferenceTO.setMsisdn(cmsAccountReference.getMsisdn());
        accountReferenceTO.setCurrency(cmsAccountReference.getCurrency());
        return accountReferenceTO;
    }

    protected AmountTO cmsAmountToAmountTO(CmsAmount cmsAmount) {
        if (cmsAmount == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(cmsAmount.getCurrency());
        amountTO.setAmount(cmsAmount.getAmount());
        return amountTO;
    }

    protected AddressTO cmsAddressToAddressTO(CmsAddress cmsAddress) {
        if (cmsAddress == null) {
            return null;
        }
        AddressTO addressTO = new AddressTO();
        addressTO.setStreet(cmsAddress.getStreet());
        addressTO.setBuildingNumber(cmsAddress.getBuildingNumber());
        addressTO.setCity(cmsAddress.getCity());
        addressTO.setPostalCode(cmsAddress.getPostalCode());
        addressTO.setCountry(cmsAddress.getCountry());
        return addressTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        TransactionStatusTO transactionStatusTO;
        if (transactionStatus == null) {
            return null;
        }
        switch (transactionStatus) {
            case ACCC: {
                transactionStatusTO = TransactionStatusTO.ACCC;
                break;
            }
            case ACCP: {
                transactionStatusTO = TransactionStatusTO.ACCP;
                break;
            }
            case ACSC: {
                transactionStatusTO = TransactionStatusTO.ACSC;
                break;
            }
            case ACSP: {
                transactionStatusTO = TransactionStatusTO.ACSP;
                break;
            }
            case ACTC: {
                transactionStatusTO = TransactionStatusTO.ACTC;
                break;
            }
            case ACWC: {
                transactionStatusTO = TransactionStatusTO.ACWC;
                break;
            }
            case ACWP: {
                transactionStatusTO = TransactionStatusTO.ACWP;
                break;
            }
            case RCVD: {
                transactionStatusTO = TransactionStatusTO.RCVD;
                break;
            }
            case PDNG: {
                transactionStatusTO = TransactionStatusTO.PDNG;
                break;
            }
            case RJCT: {
                transactionStatusTO = TransactionStatusTO.RJCT;
                break;
            }
            case CANC: {
                transactionStatusTO = TransactionStatusTO.CANC;
                break;
            }
            case ACFC: {
                transactionStatusTO = TransactionStatusTO.ACFC;
                break;
            }
            case PATC: {
                transactionStatusTO = TransactionStatusTO.PATC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + transactionStatus);
            }
        }
        return transactionStatusTO;
    }

    protected FrequencyCodeTO frequencyCodeToFrequencyCodeTO(FrequencyCode frequencyCode) {
        FrequencyCodeTO frequencyCodeTO;
        if (frequencyCode == null) {
            return null;
        }
        switch (frequencyCode) {
            case DAILY: {
                frequencyCodeTO = FrequencyCodeTO.DAILY;
                break;
            }
            case WEEKLY: {
                frequencyCodeTO = FrequencyCodeTO.WEEKLY;
                break;
            }
            case EVERYTWOWEEKS: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
                break;
            }
            case MONTHLY: {
                frequencyCodeTO = FrequencyCodeTO.MONTHLY;
                break;
            }
            case EVERYTWOMONTHS: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
                break;
            }
            case QUARTERLY: {
                frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
                break;
            }
            case SEMIANNUAL: {
                frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
                break;
            }
            case ANNUAL: {
                frequencyCodeTO = FrequencyCodeTO.ANNUAL;
                break;
            }
            case MONTHLYVARIABLE: {
                frequencyCodeTO = FrequencyCodeTO.MONTHLYVARIABLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequencyCode);
            }
        }
        return frequencyCodeTO;
    }

    protected List<SinglePaymentTO> cmsSinglePaymentListToSinglePaymentTOList(List<CmsSinglePayment> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SinglePaymentTO> list1 = new ArrayList<SinglePaymentTO>(list.size());
        for (CmsSinglePayment cmsSinglePayment : list) {
            list1.add(this.toPayment(cmsSinglePayment));
        }
        return list1;
    }
}

