/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.api.domain;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class PaymentWorkflow {
    private final CmsPaymentResponse paymentResponse;
    private String paymentStatus;
    private String authCodeMessage;
    private PaymentAuthorizeResponse authResponse;
    private final ConsentReference consentReference;
    private GlobalScaResponseTO scaResponse;

    public PaymentWorkflow(@NotNull CmsPaymentResponse paymentResponse, ConsentReference consentReference) {
        if (consentReference == null) {
            throw new IllegalStateException("Do not allow null input.");
        }
        this.paymentResponse = paymentResponse;
        this.consentReference = consentReference;
    }

    public String paymentId() {
        return this.paymentResponse.getPayment().getPaymentId();
    }

    public String authId() {
        return this.paymentResponse.getAuthorisationId();
    }

    public String encryptedConsentId() {
        return this.consentReference.getEncryptedConsentId();
    }

    public BearerTokenTO bearerToken() {
        return this.scaResponse == null ? null : this.scaResponse.getBearerToken();
    }

    public PaymentTypeTO paymentType() {
        return PaymentTypeTO.valueOf((String)this.paymentResponse.getPayment().getPaymentType().name());
    }

    public boolean singleScaMethod() {
        return this.scaResponse.getScaMethods() != null && this.scaResponse.getScaMethods().size() == 1;
    }

    public List<ScaUserDataTO> scaMethods() {
        return this.scaResponse.getScaMethods();
    }

    public ScaStatusTO scaStatus() {
        return this.scaResponse.getScaStatus();
    }

    public void processSCAResponse(GlobalScaResponseTO paymentResponse) {
        if (paymentResponse.getBearerToken() == null) {
            paymentResponse.setBearerToken(this.scaResponse.getBearerToken());
        }
        this.scaResponse = paymentResponse;
        Optional.ofNullable(paymentResponse.getAuthorisationId()).ifPresent(this.authResponse::setAuthorisationId);
        this.authResponse.setScaStatus(paymentResponse.getScaStatus());
        this.authResponse.setScaMethods(paymentResponse.getScaMethods());
        this.authResponse.setAuthConfirmationCode(paymentResponse.getAuthConfirmationCode());
        this.authCodeMessage = paymentResponse.getPsuMessage();
    }

    public CmsPaymentResponse getPaymentResponse() {
        return this.paymentResponse;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public String getAuthCodeMessage() {
        return this.authCodeMessage;
    }

    public PaymentAuthorizeResponse getAuthResponse() {
        return this.authResponse;
    }

    public ConsentReference getConsentReference() {
        return this.consentReference;
    }

    public GlobalScaResponseTO getScaResponse() {
        return this.scaResponse;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public void setAuthCodeMessage(String authCodeMessage) {
        this.authCodeMessage = authCodeMessage;
    }

    public void setAuthResponse(PaymentAuthorizeResponse authResponse) {
        this.authResponse = authResponse;
    }

    public void setScaResponse(GlobalScaResponseTO scaResponse) {
        this.scaResponse = scaResponse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentWorkflow)) {
            return false;
        }
        PaymentWorkflow other = (PaymentWorkflow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CmsPaymentResponse this$paymentResponse = this.getPaymentResponse();
        CmsPaymentResponse other$paymentResponse = other.getPaymentResponse();
        if (this$paymentResponse == null ? other$paymentResponse != null : !this$paymentResponse.equals(other$paymentResponse)) {
            return false;
        }
        String this$paymentStatus = this.getPaymentStatus();
        String other$paymentStatus = other.getPaymentStatus();
        if (this$paymentStatus == null ? other$paymentStatus != null : !this$paymentStatus.equals(other$paymentStatus)) {
            return false;
        }
        String this$authCodeMessage = this.getAuthCodeMessage();
        String other$authCodeMessage = other.getAuthCodeMessage();
        if (this$authCodeMessage == null ? other$authCodeMessage != null : !this$authCodeMessage.equals(other$authCodeMessage)) {
            return false;
        }
        PaymentAuthorizeResponse this$authResponse = this.getAuthResponse();
        PaymentAuthorizeResponse other$authResponse = other.getAuthResponse();
        if (this$authResponse == null ? other$authResponse != null : !((Object)this$authResponse).equals(other$authResponse)) {
            return false;
        }
        ConsentReference this$consentReference = this.getConsentReference();
        ConsentReference other$consentReference = other.getConsentReference();
        if (this$consentReference == null ? other$consentReference != null : !((Object)this$consentReference).equals(other$consentReference)) {
            return false;
        }
        GlobalScaResponseTO this$scaResponse = this.getScaResponse();
        GlobalScaResponseTO other$scaResponse = other.getScaResponse();
        return !(this$scaResponse == null ? other$scaResponse != null : !this$scaResponse.equals(other$scaResponse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentWorkflow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CmsPaymentResponse $paymentResponse = this.getPaymentResponse();
        result = result * 59 + ($paymentResponse == null ? 43 : $paymentResponse.hashCode());
        String $paymentStatus = this.getPaymentStatus();
        result = result * 59 + ($paymentStatus == null ? 43 : $paymentStatus.hashCode());
        String $authCodeMessage = this.getAuthCodeMessage();
        result = result * 59 + ($authCodeMessage == null ? 43 : $authCodeMessage.hashCode());
        PaymentAuthorizeResponse $authResponse = this.getAuthResponse();
        result = result * 59 + ($authResponse == null ? 43 : ((Object)$authResponse).hashCode());
        ConsentReference $consentReference = this.getConsentReference();
        result = result * 59 + ($consentReference == null ? 43 : ((Object)$consentReference).hashCode());
        GlobalScaResponseTO $scaResponse = this.getScaResponse();
        result = result * 59 + ($scaResponse == null ? 43 : $scaResponse.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentWorkflow(paymentResponse=" + this.getPaymentResponse() + ", paymentStatus=" + this.getPaymentStatus() + ", authCodeMessage=" + this.getAuthCodeMessage() + ", authResponse=" + this.getAuthResponse() + ", consentReference=" + this.getConsentReference() + ", scaResponse=" + this.getScaResponse() + ")";
    }
}

