/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.service.api.domain;

import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.oba.service.api.domain.ConsentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import java.util.Optional;

public class ConsentWorkflow {
    private final CmsAisConsentResponse consentResponse;
    private String consentStatus;
    private String authCodeMessage;
    private ConsentAuthorizeResponse authResponse;
    private final ConsentReference consentReference;
    private SCAResponseTO scaResponse;

    public ConsentWorkflow(CmsAisConsentResponse consentResponse, ConsentReference consentReference) {
        if (consentResponse == null || consentReference == null) {
            throw new IllegalStateException("Do not allow null input.");
        }
        this.consentResponse = consentResponse;
        this.consentReference = consentReference;
    }

    public BearerTokenTO bearerToken() {
        return this.scaResponse == null ? null : this.scaResponse.getBearerToken();
    }

    public String authId() {
        return this.consentResponse.getAuthorisationId();
    }

    public String encryptedConsentId() {
        return this.consentReference.getEncryptedConsentId();
    }

    public String consentId() {
        return this.consentResponse.getAccountConsent().getId();
    }

    public ScaStatusTO scaStatus() {
        return this.scaResponse.getScaStatus();
    }

    public void storeSCAResponse(SCAResponseTO consentResponse) {
        Optional.ofNullable(consentResponse).ifPresent(r -> {
            this.scaResponse = r;
            this.authResponse.setAuthorisationId(r.getAuthorisationId());
            this.authResponse.setScaStatus(r.getScaStatus());
            this.authResponse.setScaMethods(r.getScaMethods());
            this.authResponse.setAuthConfirmationCode(r.getAuthConfirmationCode());
            this.authCodeMessage = r.getPsuMessage();
        });
    }

    public CmsAisConsentResponse getConsentResponse() {
        return this.consentResponse;
    }

    public String getConsentStatus() {
        return this.consentStatus;
    }

    public String getAuthCodeMessage() {
        return this.authCodeMessage;
    }

    public ConsentAuthorizeResponse getAuthResponse() {
        return this.authResponse;
    }

    public ConsentReference getConsentReference() {
        return this.consentReference;
    }

    public SCAResponseTO getScaResponse() {
        return this.scaResponse;
    }

    public void setConsentStatus(String consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setAuthCodeMessage(String authCodeMessage) {
        this.authCodeMessage = authCodeMessage;
    }

    public void setAuthResponse(ConsentAuthorizeResponse authResponse) {
        this.authResponse = authResponse;
    }

    public void setScaResponse(SCAResponseTO scaResponse) {
        this.scaResponse = scaResponse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsentWorkflow)) {
            return false;
        }
        ConsentWorkflow other = (ConsentWorkflow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CmsAisConsentResponse this$consentResponse = this.getConsentResponse();
        CmsAisConsentResponse other$consentResponse = other.getConsentResponse();
        if (this$consentResponse == null ? other$consentResponse != null : !this$consentResponse.equals(other$consentResponse)) {
            return false;
        }
        String this$consentStatus = this.getConsentStatus();
        String other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        String this$authCodeMessage = this.getAuthCodeMessage();
        String other$authCodeMessage = other.getAuthCodeMessage();
        if (this$authCodeMessage == null ? other$authCodeMessage != null : !this$authCodeMessage.equals(other$authCodeMessage)) {
            return false;
        }
        ConsentAuthorizeResponse this$authResponse = this.getAuthResponse();
        ConsentAuthorizeResponse other$authResponse = other.getAuthResponse();
        if (this$authResponse == null ? other$authResponse != null : !((Object)this$authResponse).equals(other$authResponse)) {
            return false;
        }
        ConsentReference this$consentReference = this.getConsentReference();
        ConsentReference other$consentReference = other.getConsentReference();
        if (this$consentReference == null ? other$consentReference != null : !((Object)this$consentReference).equals(other$consentReference)) {
            return false;
        }
        SCAResponseTO this$scaResponse = this.getScaResponse();
        SCAResponseTO other$scaResponse = other.getScaResponse();
        return !(this$scaResponse == null ? other$scaResponse != null : !this$scaResponse.equals(other$scaResponse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsentWorkflow;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CmsAisConsentResponse $consentResponse = this.getConsentResponse();
        result = result * 59 + ($consentResponse == null ? 43 : $consentResponse.hashCode());
        String $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        String $authCodeMessage = this.getAuthCodeMessage();
        result = result * 59 + ($authCodeMessage == null ? 43 : $authCodeMessage.hashCode());
        ConsentAuthorizeResponse $authResponse = this.getAuthResponse();
        result = result * 59 + ($authResponse == null ? 43 : ((Object)$authResponse).hashCode());
        ConsentReference $consentReference = this.getConsentReference();
        result = result * 59 + ($consentReference == null ? 43 : ((Object)$consentReference).hashCode());
        SCAResponseTO $scaResponse = this.getScaResponse();
        result = result * 59 + ($scaResponse == null ? 43 : $scaResponse.hashCode());
        return result;
    }

    public String toString() {
        return "ConsentWorkflow(consentResponse=" + this.getConsentResponse() + ", consentStatus=" + this.getConsentStatus() + ", authCodeMessage=" + this.getAuthCodeMessage() + ", authResponse=" + this.getAuthResponse() + ", consentReference=" + this.getConsentReference() + ", scaResponse=" + this.getScaResponse() + ")";
    }
}

