/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.ws.domain;

import de.adorsys.ledgers.oba.service.api.domain.DecoupledConfRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.stereotype.Component;

@Component
public class DecoupledContext {
    private final Map<String, List<DecoupledConfRequest>> undeliveredDecoupledMessages = new HashMap<String, List<DecoupledConfRequest>>();
    private final SimpUserRegistry simpUserRegistry;

    public List<DecoupledConfRequest> getUndeliveredMessages(String userLogin) {
        return Optional.ofNullable(this.undeliveredDecoupledMessages.get(userLogin)).orElseGet(ArrayList::new);
    }

    public void addUndeliveredMessage(String login, DecoupledConfRequest message) {
        List<DecoupledConfRequest> unsentMessages = this.getUndeliveredMessages(login);
        unsentMessages.add(message);
        this.undeliveredDecoupledMessages.put(login, unsentMessages);
    }

    public void clearUndeliveredMessages(String login) {
        this.undeliveredDecoupledMessages.remove(login);
    }

    public boolean checkUserIsConnected(String login) {
        return this.simpUserRegistry.getUsers().stream().map(SimpUser::getName).anyMatch(login::equals);
    }

    public Map<String, List<DecoupledConfRequest>> getUndeliveredDecoupledMessages() {
        return this.undeliveredDecoupledMessages;
    }

    public SimpUserRegistry getSimpUserRegistry() {
        return this.simpUserRegistry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecoupledContext)) {
            return false;
        }
        DecoupledContext other = (DecoupledContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<DecoupledConfRequest>> this$undeliveredDecoupledMessages = this.getUndeliveredDecoupledMessages();
        Map<String, List<DecoupledConfRequest>> other$undeliveredDecoupledMessages = other.getUndeliveredDecoupledMessages();
        if (this$undeliveredDecoupledMessages == null ? other$undeliveredDecoupledMessages != null : !((Object)this$undeliveredDecoupledMessages).equals(other$undeliveredDecoupledMessages)) {
            return false;
        }
        SimpUserRegistry this$simpUserRegistry = this.getSimpUserRegistry();
        SimpUserRegistry other$simpUserRegistry = other.getSimpUserRegistry();
        return !(this$simpUserRegistry == null ? other$simpUserRegistry != null : !this$simpUserRegistry.equals(other$simpUserRegistry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DecoupledContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<DecoupledConfRequest>> $undeliveredDecoupledMessages = this.getUndeliveredDecoupledMessages();
        result = result * 59 + ($undeliveredDecoupledMessages == null ? 43 : ((Object)$undeliveredDecoupledMessages).hashCode());
        SimpUserRegistry $simpUserRegistry = this.getSimpUserRegistry();
        result = result * 59 + ($simpUserRegistry == null ? 43 : $simpUserRegistry.hashCode());
        return result;
    }

    public String toString() {
        return "DecoupledContext(undeliveredDecoupledMessages=" + this.getUndeliveredDecoupledMessages() + ", simpUserRegistry=" + this.getSimpUserRegistry() + ")";
    }

    public DecoupledContext(SimpUserRegistry simpUserRegistry) {
        this.simpUserRegistry = simpUserRegistry;
    }
}

