/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.ws.config;

import de.adorsys.ledgers.oba.rest.server.ws.config.CustomHandshakeHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.HandshakeHandler;

@Configuration
@EnableWebSocketMessageBroker
public class SocketBrokerConfig
implements WebSocketMessageBrokerConfigurer {
    private final CustomHandshakeHandler handler;

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.setApplicationDestinationPrefixes(new String[]{"/app"}).enableSimpleBroker(new String[]{"/msg"});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/socket"}).setAllowedOrigins(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handler);
    }

    public SocketBrokerConfig(CustomHandshakeHandler handler) {
        this.handler = handler;
    }
}

