/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.oba;

import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.middleware.client.rest.RedirectScaRestClient;
import de.adorsys.ledgers.oba.rest.api.resource.oba.ObaCancellationApi;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.util.EnumSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/payment/cancellation"})
public class ObaCancellationController
implements ObaCancellationApi {
    private static final Logger log = LoggerFactory.getLogger(ObaCancellationController.class);
    private final CmsPsuPisService cmsPsuPisService;
    private final PaymentRestClient paymentRestClient;
    private final RedirectScaRestClient redirectScaRestClient;
    private final AuthRequestInterceptor auth;

    public ResponseEntity<SCAPaymentResponseTO> initCancellation(String paymentId) {
        SCAPaymentResponseTO response = (SCAPaymentResponseTO)this.paymentRestClient.initiatePmtCancellation(paymentId).getBody();
        HttpStatus status = this.resolveStatus(paymentId, Objects.requireNonNull(response));
        return new ResponseEntity((Object)response, status);
    }

    public ResponseEntity<SCAPaymentResponseTO> selectSca(String paymentId, String cancellationId, String scaMethodId) {
        StartScaOprTO opr = new StartScaOprTO(paymentId, null, cancellationId, OpTypeTO.CANCEL_PAYMENT);
        this.redirectScaRestClient.startSca(opr);
        return ResponseEntity.ok((Object)this.mapToPaymentResponse(Objects.requireNonNull((GlobalScaResponseTO)this.redirectScaRestClient.selectMethod(cancellationId, scaMethodId).getBody())));
    }

    private SCAPaymentResponseTO mapToPaymentResponse(GlobalScaResponseTO source) {
        SCAPaymentResponseTO target = new SCAPaymentResponseTO();
        target.setPaymentId(source.getOperationObjectId());
        target.setScaStatus(source.getScaStatus());
        target.setAuthorisationId(source.getAuthorisationId());
        target.setScaMethods(source.getScaMethods());
        target.setChallengeData(source.getChallengeData());
        target.setPsuMessage(source.getPsuMessage());
        target.setStatusDate(source.getStatusDate());
        target.setExpiresInSeconds(source.getExpiresInSeconds());
        target.setMultilevelScaRequired(source.isMultilevelScaRequired());
        target.setAuthConfirmationCode(source.getAuthConfirmationCode());
        target.setBearerToken(source.getBearerToken());
        target.setObjectType(source.getOpType().name());
        return target;
    }

    public ResponseEntity<Void> validateTAN(String paymentId, String cancellationId, String authCode) {
        GlobalScaResponseTO validateScaCode = (GlobalScaResponseTO)this.redirectScaRestClient.validateScaCode(cancellationId, authCode).getBody();
        this.auth.setAccessToken(Objects.requireNonNull(validateScaCode).getBearerToken().getAccess_token());
        SCAPaymentResponseTO response = (SCAPaymentResponseTO)this.paymentRestClient.executeCancelPayment(paymentId).getBody();
        HttpStatus status = this.resolveStatus(paymentId, Objects.requireNonNull(response));
        return new ResponseEntity(status);
    }

    private HttpStatus resolveStatus(String paymentId, SCAPaymentResponseTO response) {
        if (EnumSet.of(ScaStatusTO.EXEMPTED, ScaStatusTO.FINALISED).contains(response.getScaStatus())) {
            return this.cmsPsuPisService.updatePaymentStatus(paymentId, TransactionStatus.CANC, "UNDEFINED") ? HttpStatus.NO_CONTENT : HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.OK;
    }

    public ObaCancellationController(CmsPsuPisService cmsPsuPisService, PaymentRestClient paymentRestClient, RedirectScaRestClient redirectScaRestClient, AuthRequestInterceptor auth) {
        this.cmsPsuPisService = cmsPsuPisService;
        this.paymentRestClient = paymentRestClient;
        this.redirectScaRestClient = redirectScaRestClient;
        this.auth = auth;
    }
}

