/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.oba;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.client.rest.PaymentRestClient;
import de.adorsys.ledgers.oba.rest.api.resource.oba.ObaAisApi;
import de.adorsys.ledgers.oba.service.api.service.AisService;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/ais"})
public class ObaAisController
implements ObaAisApi {
    private static final Logger log = LoggerFactory.getLogger(ObaAisController.class);
    private final AisService aisService;
    private final PaymentRestClient paymentRestClient;

    @PreAuthorize(value="#userLogin == authentication.principal.login")
    public ResponseEntity<List<AccountDetailsTO>> accounts(String userLogin) {
        return ResponseEntity.ok((Object)this.aisService.getAccounts(userLogin));
    }

    public ResponseEntity<AccountDetailsTO> account(String accountId) {
        return ResponseEntity.ok((Object)this.aisService.getAccount(accountId));
    }

    public ResponseEntity<List<TransactionTO>> transactions(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        return ResponseEntity.ok((Object)this.aisService.getTransactions(accountId, dateFrom, dateTo));
    }

    public ResponseEntity<CustomPageImpl<TransactionTO>> transactions(String accountId, LocalDate dateFrom, LocalDate dateTo, int page, int size) {
        return ResponseEntity.ok((Object)this.aisService.getTransactions(accountId, dateFrom, dateTo, page, size));
    }

    public ResponseEntity<CustomPageImpl<PaymentTO>> getPendingPeriodicPayments(int page, int size) {
        return this.paymentRestClient.getPendingPeriodicPaymentsPaged(page, size);
    }

    public ObaAisController(AisService aisService, PaymentRestClient paymentRestClient) {
        this.aisService = aisService;
        this.paymentRestClient = paymentRestClient;
    }
}

