/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.config.security;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.client.rest.AuthRequestInterceptor;
import de.adorsys.ledgers.oba.rest.server.auth.JWTAuthenticationFilter;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.auth.oba.LoginAuthenticationFilter;
import de.adorsys.ledgers.oba.rest.server.auth.oba.TokenAuthenticationFilter;
import de.adorsys.ledgers.oba.rest.server.config.security.PermittedResources;
import de.adorsys.ledgers.oba.service.api.service.TokenAuthenticationService;
import java.security.Principal;
import java.util.Optional;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.context.annotation.RequestScope;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    @Bean
    @RequestScope
    public Principal getPrincipal() {
        return WebSecurityConfig.auth().orElse(null);
    }

    @Bean
    @RequestScope
    public ObaMiddlewareAuthentication getMiddlewareAuthentication() {
        return WebSecurityConfig.auth().orElse(null);
    }

    @Bean
    @RequestScope
    public AccessTokenTO getAccessToken() {
        return WebSecurityConfig.auth().map(this::extractToken).orElse(null);
    }

    private static Optional<ObaMiddlewareAuthentication> auth() {
        return SecurityContextHolder.getContext() == null || !(SecurityContextHolder.getContext().getAuthentication() instanceof ObaMiddlewareAuthentication) ? Optional.empty() : Optional.of((ObaMiddlewareAuthentication)SecurityContextHolder.getContext().getAuthentication());
    }

    private AccessTokenTO extractToken(ObaMiddlewareAuthentication authentication) {
        return authentication.getBearerToken().getAccessTokenObject();
    }

    @Order(value=2)
    @Configuration
    public static class ObaScaSecurityConfig
    extends WebSecurityConfigurerAdapter {
        private final TokenAuthenticationService tokenAuthenticationService;
        private final AuthRequestInterceptor authInterceptor;

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(PermittedResources.APP_INDEX_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.APP_SCA_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.APP_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.SWAGGER_WHITELIST)).permitAll().and()).authorizeRequests().antMatchers(PermittedResources.ACTUATOR_WHITELIST)).permitAll().and()).cors().and()).authorizeRequests().anyRequest()).authenticated();
            ((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
            http.headers().frameOptions().disable();
            http.addFilterBefore((Filter)new JWTAuthenticationFilter(this.tokenAuthenticationService, this.authInterceptor), BasicAuthenticationFilter.class);
        }

        public ObaScaSecurityConfig(TokenAuthenticationService tokenAuthenticationService, AuthRequestInterceptor authInterceptor) {
            this.tokenAuthenticationService = tokenAuthenticationService;
            this.authInterceptor = authInterceptor;
        }
    }

    @Order(value=1)
    @Configuration
    public static class ObaSecurityConfig
    extends WebSecurityConfigurerAdapter {
        private final AuthRequestInterceptor authInterceptor;
        private final KeycloakTokenService tokenService;

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/api/v1/**").authorizeRequests().antMatchers(PermittedResources.APP_WHITELIST)).permitAll().and()).authorizeRequests().anyRequest()).authenticated().and()).httpBasic().disable();
            ((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
            http.headers().frameOptions().disable();
            http.addFilterBefore((Filter)new LoginAuthenticationFilter(this.tokenService), BasicAuthenticationFilter.class);
            http.addFilterBefore((Filter)new TokenAuthenticationFilter(this.authInterceptor, this.tokenService), BasicAuthenticationFilter.class);
        }

        public ObaSecurityConfig(AuthRequestInterceptor authInterceptor, KeycloakTokenService tokenService) {
            this.authInterceptor = authInterceptor;
            this.tokenService = tokenService;
        }
    }
}

