/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.auth.oba;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.oba.rest.server.auth.oba.AbstractAuthFilter;
import feign.FeignException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class LoginAuthenticationFilter
extends AbstractAuthFilter {
    private final KeycloakTokenService tokenService;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String login = this.obtainFromHeader(request, "login");
        String pin = this.obtainFromHeader(request, "pin");
        if (StringUtils.isBlank((CharSequence)login) || StringUtils.isBlank((CharSequence)pin)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.authenticationIsRequired()) {
            try {
                BearerTokenTO bearerTokenTO = this.tokenService.login(login, pin);
                bearerTokenTO = this.tokenService.validate(bearerTokenTO.getAccess_token());
                if (UserRoleTO.CUSTOMER != bearerTokenTO.getAccessTokenObject().getRole()) {
                    this.handleAuthenticationFailure(response, new IllegalAccessException(String.format("User %s is missing required Role to login", login)));
                    return;
                }
                this.fillSecurityContext(bearerTokenTO);
                this.addBearerTokenHeader(bearerTokenTO.getAccess_token(), response);
            }
            catch (FeignException e) {
                this.handleAuthenticationFailure(response, (Exception)((Object)e));
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void addBearerTokenHeader(String token, HttpServletResponse response) {
        response.setHeader("access_token", token);
    }

    public LoginAuthenticationFilter(KeycloakTokenService tokenService) {
        this.tokenService = tokenService;
    }
}

