/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.ws.controller;

import de.adorsys.ledgers.oba.rest.server.ws.domain.DecoupledContext;
import de.adorsys.ledgers.oba.service.api.domain.DecoupledConfRequest;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.messaging.AbstractSubProtocolEvent;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

@Service
public class DecoupledSessionListener {
    private static final Logger log = LoggerFactory.getLogger(DecoupledSessionListener.class);
    private final SimpMessagingTemplate template;
    private final DecoupledContext context;

    @EventListener
    public void handleSubscribeEvent(SessionSubscribeEvent event) {
        String user = Optional.ofNullable(event).map(AbstractSubProtocolEvent::getUser).map(Principal::getName).orElse("UNKNOWN");
        log.info("User: {} connected", (Object)user);
        List<DecoupledConfRequest> undeliveredMessages = this.context.getUndeliveredMessages(user);
        if (CollectionUtils.isNotEmpty(undeliveredMessages)) {
            log.info("Delivering {} messages to recently connected user: {}", (Object)undeliveredMessages.size(), (Object)user);
            undeliveredMessages.forEach(m -> this.template.convertAndSendToUser(m.getAddressedUser(), "/msg", m));
            this.context.clearUndeliveredMessages(user);
        }
    }

    @EventListener
    public void handleUnsubscribeEvent(SessionDisconnectEvent event) {
        String user = Optional.ofNullable(event).map(AbstractSubProtocolEvent::getUser).map(Principal::getName).orElse("UNKNOWN");
        log.info("User {} disconnected", (Object)user);
    }

    public DecoupledSessionListener(SimpMessagingTemplate template, DecoupledContext context) {
        this.template = template;
        this.context = context;
    }
}

