/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.ws.controller;

import de.adorsys.ledgers.oba.rest.api.resource.oba.ObaDecoupledAPI;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.ws.domain.DecoupledContext;
import de.adorsys.ledgers.oba.service.api.domain.DecoupledConfRequest;
import de.adorsys.ledgers.oba.service.api.service.DecoupledService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/decoupled"})
public class DecoupledController
implements ObaDecoupledAPI {
    private static final Logger log = LoggerFactory.getLogger(DecoupledController.class);
    private final SimpMessagingTemplate template;
    private final DecoupledContext context;
    private final ObaMiddlewareAuthentication authentication;
    private final DecoupledService decoupledService;

    public ResponseEntity<Boolean> decoupled(DecoupledConfRequest message) {
        log.info("Confirmation of decoupled operation: {}, id: {}, by: {}", new Object[]{message.getOpType().name(), message.getObjId(), message.getAddressedUser()});
        return ResponseEntity.ok((Object)this.decoupledService.executeDecoupledOpr(message, this.authentication.getBearerToken().getAccess_token()));
    }

    public ResponseEntity<Boolean> sendNotification(DecoupledConfRequest message) {
        message.setConfirmationUrl("/api/v1/decoupled/execute");
        message.setHttpMethod(HttpMethod.POST);
        if (this.context.checkUserIsConnected(message.getAddressedUser())) {
            log.info("Sending decoupled notification to connected user: {}, operation type: {}, opId: {}", new Object[]{message.getAddressedUser(), message.getOpType().name(), message.getObjId()});
            this.template.convertAndSendToUser(message.getAddressedUser(), "/msg", (Object)message);
        } else {
            log.info("User: {} is not connected! Adding received message to messages queue.", (Object)message.getAddressedUser());
            this.context.addUndeliveredMessage(message.getAddressedUser(), message);
        }
        return ResponseEntity.ok((Object)true);
    }

    public DecoupledController(SimpMessagingTemplate template, DecoupledContext context, ObaMiddlewareAuthentication authentication, DecoupledService decoupledService) {
        this.template = template;
        this.context = context;
        this.authentication = authentication;
        this.decoupledService = decoupledService;
    }
}

