/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource.exception.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.oba.rest.server.auth.oba.ErrorResponse;
import de.adorsys.ledgers.oba.rest.server.resource.exception.resolver.AisExceptionStatusResolver;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import feign.FeignException;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.HandlerMethod;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String DEV_MESSAGE = "devMessage";
    private final ObjectMapper objectMapper;

    @ExceptionHandler(value={ObaException.class})
    public ResponseEntity<Map<String, String>> handleAisException(ObaException e) {
        HttpStatus status = AisExceptionStatusResolver.resolveHttpStatusByCode(e.getObaErrorCode());
        Map<String, String> message = this.buildContentMap(status.value(), e.getDevMessage());
        return ResponseEntity.status((HttpStatus)status).body(message);
    }

    @ExceptionHandler(value={FeignException.class})
    public ResponseEntity<Map<String, String>> handleFeignException(FeignException ex, HandlerMethod handlerMethod) {
        log.warn("FeignException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        Map<String, String> body = this.buildContentMap(ex.status(), this.resolveErrorMessage(ex));
        HttpStatus status = HttpStatus.I_AM_A_TEAPOT;
        try {
            status = HttpStatus.valueOf((int)ex.status());
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage());
        }
        return new ResponseEntity(body, status);
    }

    @ExceptionHandler(value={ConnectException.class})
    public ResponseEntity<Map<String, String>> handleAuthException(ConnectException e) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        Map<String, String> message = this.buildContentMap(status.value(), e.getMessage());
        return ResponseEntity.status((HttpStatus)status).body(message);
    }

    private Map<String, String> buildContentMap(int code, String message) {
        return new ErrorResponse().buildContent(code, message);
    }

    private String resolveErrorMessage(FeignException ex) {
        return ex.responseBody().map(ByteBuffer::array).map(b -> this.extractMessage(ex, (byte[])b)).orElse(ex.getMessage());
    }

    private String extractMessage(FeignException ex, byte[] b) {
        try {
            return Optional.ofNullable(this.objectMapper.readTree(b).get(DEV_MESSAGE)).map(JsonNode::asText).orElseGet(ex::getMessage);
        }
        catch (IOException e) {
            log.warn("Couldn't read json content");
            return ex.getMessage();
        }
    }

    public GlobalExceptionHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

