/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.oba.rest.server.resource;

import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.oba.rest.server.auth.ObaMiddlewareAuthentication;
import de.adorsys.ledgers.oba.rest.server.resource.AuthUtils;
import de.adorsys.ledgers.oba.rest.server.resource.ResponseUtils;
import de.adorsys.ledgers.oba.service.api.domain.AuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.ConsentReference;
import de.adorsys.ledgers.oba.service.api.domain.ConsentType;
import de.adorsys.ledgers.oba.service.api.domain.PaymentAuthorizeResponse;
import de.adorsys.ledgers.oba.service.api.domain.PaymentWorkflow;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaErrorCode;
import de.adorsys.ledgers.oba.service.api.domain.exception.ObaException;
import de.adorsys.ledgers.oba.service.api.service.CmsAspspConsentDataService;
import de.adorsys.ledgers.oba.service.api.service.CommonPaymentService;
import de.adorsys.ledgers.oba.service.api.service.ConsentReferencePolicy;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuAisClient;
import org.adorsys.ledgers.consent.psu.rest.client.CmsPsuPisClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class XISControllerService {
    private static final Logger log = LoggerFactory.getLogger(XISControllerService.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ConsentReferencePolicy referencePolicy;
    private final ResponseUtils responseUtils;
    private final KeycloakTokenService tokenService;
    private final CommonPaymentService paymentService;
    private final ObaMiddlewareAuthentication middlewareAuth;
    private final CmsAspspConsentDataService consentDataService;
    private final CmsPsuAisClient cmsPsuAisClient;
    private final CmsPsuPisClient cmsPsuPisClient;
    @Value(value="${online-banking.sca.loginpage:http://localhost:4400/}")
    private String loginPage;

    public ResponseEntity<AuthorizeResponse> auth(String redirectId, ConsentType consentType, String encryptedConsentId, HttpServletResponse response) {
        AuthorizeResponse authResponse = new AuthorizeResponse();
        ConsentReference consentReference = this.referencePolicy.fromURL(redirectId, consentType, encryptedConsentId);
        authResponse.setEncryptedConsentId(encryptedConsentId);
        authResponse.setAuthorisationId(redirectId);
        String token = Optional.ofNullable(this.request.getHeader("Authorization")).filter(t -> StringUtils.startsWithIgnoreCase((CharSequence)t, (CharSequence)"Bearer ")).map(t -> StringUtils.substringAfter((String)t, (String)"Bearer ")).orElse(null);
        AccessTokenTO tokenTO = Optional.ofNullable(token).map(arg_0 -> ((KeycloakTokenService)this.tokenService).validate(arg_0)).map(BearerTokenTO::getAccessTokenObject).orElse(null);
        this.responseUtils.setCookies(response, consentReference, token, tokenTO);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            response.addHeader("Authorization", token);
        }
        String uriString = UriComponentsBuilder.fromUriString((String)this.loginPage).queryParam("encryptedConsentId", new Object[]{authResponse.getEncryptedConsentId()}).queryParam("authorisationId", new Object[]{authResponse.getAuthorisationId()}).build().toUriString();
        response.addHeader("Location", uriString);
        return ResponseEntity.ok((Object)authResponse);
    }

    public ResponseEntity<PaymentAuthorizeResponse> resolvePaymentWorkflow(PaymentWorkflow workflow) {
        ScaStatusTO scaStatusTO = workflow.scaStatus();
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.FINALISED, ScaStatusTO.EXEMPTED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.SCAMETHODSELECTED).contains(scaStatusTO)) {
            this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
            return ResponseEntity.ok((Object)workflow.getAuthResponse());
        }
        this.responseUtils.removeCookies(this.response);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).build();
    }

    public ResponseEntity<PaymentAuthorizeResponse> selectScaMethod(String encryptedPaymentId, String authorisationId, String scaMethodId, String consentAndaccessTokenCookieString) {
        String consentCookie = this.responseUtils.consentCookie(consentAndaccessTokenCookieString);
        PaymentWorkflow workflow = this.paymentService.selectScaForPayment(encryptedPaymentId, authorisationId, scaMethodId, consentCookie, AuthUtils.psuId(this.middlewareAuth), this.middlewareAuth.getBearerToken());
        this.responseUtils.setCookies(this.response, workflow.getConsentReference(), workflow.bearerToken().getAccess_token(), workflow.bearerToken().getAccessTokenObject());
        return ResponseEntity.ok((Object)workflow.getAuthResponse());
    }

    public void checkFailedCount(String encryptedId) {
        if (this.consentDataService.isFailedLogin(encryptedId)) {
            throw ObaException.builder().devMessage("You have exceeded maximum login attempts for current Authorization!").obaErrorCode(ObaErrorCode.AUTH_EXPIRED).build();
        }
    }

    public void resolveFailedLoginAttempt(String encryptedId, String id, String login, String authId, OpTypeTO opType) {
        int attemptsLeft = this.consentDataService.updateLoginFailedCount(encryptedId);
        if (attemptsLeft < 1) {
            if (opType == OpTypeTO.CONSENT) {
                this.failConsentAuthorization(id, login, authId);
            } else {
                this.failPaymentAuthorisation(id, login, authId);
            }
            this.responseUtils.removeCookies(this.response);
        }
        String msg = attemptsLeft > 0 ? String.format("You have %s attempts left", attemptsLeft) : "You've exceeded login attempts limit for current session. Please open new Authorization session";
        throw ObaException.builder().devMessage(String.format("Login Failed!%n %s", msg)).obaErrorCode(ObaErrorCode.LOGIN_FAILED).build();
    }

    private void failConsentAuthorization(String id, String login, String authId) {
        this.cmsPsuAisClient.updateAuthorisationStatus(id, "FAILED", authId, login, null, null, null, "UNDEFINED", new AuthenticationDataHolder(null, null));
    }

    private void failPaymentAuthorisation(String id, String login, String authId) {
        this.cmsPsuPisClient.updateAuthorisationStatus(login, null, null, null, id, authId, "FAILED", "UNDEFINED", new AuthenticationDataHolder(null, null));
    }

    public XISControllerService(HttpServletRequest request, HttpServletResponse response, ConsentReferencePolicy referencePolicy, ResponseUtils responseUtils, KeycloakTokenService tokenService, CommonPaymentService paymentService, ObaMiddlewareAuthentication middlewareAuth, CmsAspspConsentDataService consentDataService, CmsPsuAisClient cmsPsuAisClient, CmsPsuPisClient cmsPsuPisClient) {
        this.request = request;
        this.response = response;
        this.referencePolicy = referencePolicy;
        this.responseUtils = responseUtils;
        this.tokenService = tokenService;
        this.paymentService = paymentService;
        this.middlewareAuth = middlewareAuth;
        this.consentDataService = consentDataService;
        this.cmsPsuAisClient = cmsPsuAisClient;
        this.cmsPsuPisClient = cmsPsuPisClient;
    }
}

